<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class api extends CI_Controller {
	/**
		* @Author				: Localhost {Ferdhika Yudira}
		* @Email				: fer@dika.web.id
		* @Web					: http://dika.web.id
		* @Date					: 2015-07-09 14:48:37
	**/
	function __construct(){
		parent::__construct();
		// Load model m_api.php
		//$this->load->model('m_api');
		$this->load->model('admin/master_model');
		header('Access-Control-Allow-Origin: *');
		//header("Content-Type: application/json; charset=UTF-8");
		header('Access-Control-Allow-Method: PUT, GET, POST, DELETE, OPTIONS');
		header('Access-Control-Allow-Headers: Content-Type, x-xsrf-token');
	}


  public function mst_data()
	{
		$modul = $_GET['modul'];
    $limit = $_GET['limit'];

		$datamaster = $this->master_model->select_in('ms_'.$modul, '*', "LIMIT $limit");

    if(!empty($datamaster))
		{
			foreach ($datamaster as $kolom) {
				// data array from database
				$json[] = array(
					'ID' 	=> $kolom->ID,
          'name' 	=> ucfirst(strtolower($kolom->name)),
          'note' 	=> $kolom->note,
					'image'  => base_url().'uploads/'.$modul.'/'.$kolom->image,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function count_activity()
	{
		$param = $_GET['param'];

		$json = array(
				'count' 	=> $this->master_model->mst_count('ts_service', "status = '$param'"),
		);

		echo json_encode($json);
	}

	public function count_product_request()
	{
		$data_spareparts = $this->master_model->select_in('ms_product_spareparts', 'SUM(request) AS request', "WHERE request > 0");
		if($data_spareparts[0]->request == '')
		{
			$request = 0;
		}else {
			$request = $data_spareparts[0]->request;
		}
		$json = array(
			'count' => $request,
		);

		echo json_encode($json);
	}

	public function recently_spareparts()
	{
		$data_spareparts=$this->master_model->select_in('ms_product_spareparts a LEFT JOIN ms_product_subcategory b ON a.id_product_subcategory = b.ID LEFT JOIN ms_product_category c ON b.id_product_category = c.ID LEFT JOIN ms_product d ON c.id_product = d.ID','a.ID AS id_spareparts, a.name, a.price, a.stock, b.name AS subcategory, c.name AS category, d.name AS product, d.ID AS id_product, c.ID AS id_product_category, b.ID AS id_product_subcategory',"ORDER BY a.ID DESC LIMIT 10");

		if(!empty($data_spareparts))
		{
			for($a=0; $a < count($data_spareparts); $a++)
			{
				$json[] = array(
						'ID' 	      => $data_spareparts[$a]->id_spareparts,
						'name'      => $data_spareparts[$a]->name,
						'category'  => ucfirst(strtolower($data_spareparts[$a]->product)).', '.ucfirst(strtolower($data_spareparts[$a]->category)).', '.ucfirst(strtolower($data_spareparts[$a]->subcategory)),
						'image'     => base_url().'assets/img/default-50x50.gif',
						'price' 	  => $data_spareparts[$a]->price,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}


	public function master_service()
	{
		$data_services=$this->master_model->select_in('ms_service','*',"ORDER BY ID DESC");

		if(!empty($data_services))
		{
			for($a=0; $a < count($data_services); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_services[$a]->ID,
						'name'       => $data_services[$a]->name,
						'price'      => str_replace(',','.', number_format($data_services[$a]->price)),
						'durations'  => $data_services[$a]->durations,
						'mechanic'   => $data_services[$a]->mechanic,
						'note'       => $data_services[$a]->note,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function search_master_service()
	{
		$param = $this->input->get('param');

		$data_services=$this->master_model->select_in('ms_service','*',"WHERE name LIKE '%$param%' ORDER BY ID");

		if(!empty($data_services))
		{
			for($a=0; $a < count($data_services); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_services[$a]->ID,
						'name'       => $data_services[$a]->name,
						'price'      => str_replace(',','.', number_format($data_services[$a]->price)),
						'durations'  => $data_services[$a]->durations,
						'mechanic'   => $data_services[$a]->mechanic,
						'note'       => $data_services[$a]->note,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function search_master_customer()
	{
		$param = $this->input->get('param');

		$data_customer=$this->master_model->select_in('ms_customer','*',"WHERE name LIKE '%$param%' ORDER BY ID");

		if(!empty($data_customer))
		{
			for($a=0; $a < count($data_customer); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_customer[$a]->ID,
						'name'       => $data_customer[$a]->name,
						'phone'      => $data_customer[$a]->phone,
						'email'      => $data_customer[$a]->email,
						'company'    => $data_customer[$a]->company,
						'company_phone'      => $data_customer[$a]->company_phone,
						'address'      => $data_customer[$a]->address,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function insert_master_service()
	{
		$postdata = file_get_contents("php://input");
    $request = json_decode($postdata);

		$name     = $request->name;
		$mechanic = $request->mechanic;
		$note     = $request->note;
		$price    = $request->price;
		$duration = $request->duration;

		$ID = $this->master_model->mst_last_id('ms_service');
		$data = array(
			'ID'        => $ID,
			'mechanic'  => $mechanic,
			'name'      => $name,
			'note'      => $note,
			'price'     => $price,
			'durations' => $duration,
			'sort'      => $ID,
			'publish'   => 1,
		);
		$this->db->insert('ms_service', $data);

		$json = array(
			'info' => 'success',
		);

		echo json_encode($json);
	}

	public function update_master_service()
	{
		$postdata = file_get_contents("php://input");
    $request = json_decode($postdata);

		$ID       = $request->ID;
		$name     = $request->name;
		$mechanic = $request->mechanic;
		$note     = $request->note;
		$price    = $request->price;
		$duration = $request->duration;

		$data = array(
			'mechanic'  => $mechanic,
			'name'      => $name,
			'note'      => $note,
			'price'     => $price,
			'durations' => $duration,
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_service', $data);

		$json = array(
			'info' => 'success',
		);

		echo json_encode($json);
	}


	public function delete_master_service()
	{
		$ID = $this->input->get('ID');

		$this->db->where('ID', $ID);
		$this->db->delete('ms_service');

		$json = array(
			'info' => 'success',
		);

		echo json_encode($json);
	}

	public function master_customer()
	{
		$data_customer=$this->master_model->select_in('ms_customer','*',"ORDER BY ID DESC");

		if(!empty($data_customer))
		{
			for($a=0; $a < count($data_customer); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_customer[$a]->ID,
						'name'       => $data_customer[$a]->name,
						'email'      => $data_customer[$a]->email,
						'phone'      => $data_customer[$a]->phone,
						'company'    => $data_customer[$a]->company,
						'company_phone'      => $data_customer[$a]->company_phone,
						'address'      => $data_customer[$a]->address,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_mechanic()
	{
		$data_mechanic=$this->master_model->select_in('ms_mechanic','*',"ORDER BY ID DESC");

		if(!empty($data_mechanic))
		{
			for($a=0; $a < count($data_mechanic); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_mechanic[$a]->ID,
						'name'       => $data_mechanic[$a]->name,
						'email'      => $data_mechanic[$a]->email,
						'phone'      => $data_mechanic[$a]->phone,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_supplier()
	{
		$data_supplier =$this->master_model->select_in('ms_supplier','*',"ORDER BY ID DESC");

		if(!empty($data_supplier))
		{
			for($a=0; $a < count($data_supplier); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_supplier[$a]->ID,
						'name'       => $data_supplier[$a]->name,
						'email'      => $data_supplier[$a]->email,
						'phone'      => $data_supplier[$a]->phone,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_product()
	{
		$data_product=$this->master_model->select_in('ms_product','*',"ORDER BY name ASC");

		if(!empty($data_product))
		{
			for($a=0; $a < count($data_product); $a++)
			{
				$ID = $data_product[$a]->ID;
				$count = count($this->master_model->select_in('ms_product_category','*',"WHERE id_product = $ID"));
				$json[] = array(
						'ID' 	       => $data_product[$a]->ID,
						'name'       => $data_product[$a]->name,
						'count_category' => $count,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function update_master_product()
	{
		$postdata = file_get_contents("php://input");
    $request = json_decode($postdata);

		$ID       = $request->ID;
		$name     = $request->name;
		$note     = $request->note;

		$data = array(
			'name'      => $name,
			'note'      => $note,
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_product', $data);

		$json = array(
			'info' => 'success',
		);

		echo json_encode($json);
	}

	public function log_service()
	{
		$data_log_activity = $this->master_model->select_in('log_activity','*',"WHERE status_read = 0 AND activity <> 'Spareparts' ORDER BY ID DESC");

		if(!empty($data_log_activity))
		{
			for($a=0; $a < count($data_log_activity); $a++)
			{
				$id_admin_log_activity = $data_log_activity[$a]->id_admin;
				$activity = $data_log_activity[$a]->activity;

				$id_detail = $data_log_activity[$a]->id_detail;

				if($activity == 'Service')
				{
					$url = 'transaction/index/27/'.$data_log_activity[$a]->id_detail;
					$data_service = $this->master_model->select_in('ts_service', 'invoice', "WHERE ID = $id_detail");
					$invoice = $data_service[0]->invoice;
				}elseif($activity == 'Jobs')
				{
					$url = 'transaction/job/28/'.$data_log_activity[$a]->id_detail;
					$data_service_detail = $this->master_model->select_in('ts_service_detail', 'id_service', "WHERE ID = $id_detail");
					$id_service = $data_service_detail[0]->id_service;

					$data_service = $this->master_model->select_in('ts_service', 'invoice', "WHERE ID = $id_service");
					$invoice = $data_service[0]->invoice;
				}elseif($activity == 'Spareparts')
				{
					$url = 'transaction/spareparts/32/'.$data_log_activity[$a]->id_detail;
				}

				$data_admin = $this->master_model->select_in('user', 'ID, name', "WHERE ID = $id_admin_log_activity");
				if($id_admin_log_activity == $data_admin[0]->ID)
				{
					$name_admin = $data_admin[0]->name;
				}else {
					$name_admin = 'You';
				}

				$json[] = array(
						'ID' 	           => $data_log_activity[$a]->ID,
						'image' 	       => base_url().'assets/img/default-50x50.gif',
						'activity'       => $data_log_activity[$a]->activity,
						'note'           => $data_log_activity[$a]->note,
						'date_in'        => date('d M Y H:i', strtotime($data_log_activity[$a]->date_in)),
						'invoice'        => $invoice,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}


	public function insert_master_product()
	{
		$postdata = file_get_contents("php://input");
    $request = json_decode($postdata);

		$name     = $request->name;
		$note     = $request->note;

		$ID = $this->master_model->mst_last_id('ms_product');
		$data = array(
			'ID'        => $ID,
			'name'      => $name,
			'note'      => $note,
			'sort'      => $ID,
			'publish'   => 1,
		);
		$this->db->insert('ms_product', $data);

		$json = array(
			'info' => 'success',
		);

		echo json_encode($json);
	}

	public function search_master_product()
	{
		$param = $this->input->get('param');

		$data_product=$this->master_model->select_in('ms_product','*',"WHERE name LIKE '%$param%' ORDER BY name ASC");

		if(!empty($data_product))
		{
			for($a=0; $a < count($data_product); $a++)
			{
				$ID = $data_product[$a]->ID;
				$count = count($this->master_model->select_in('ms_product_category','*',"WHERE id_product = $ID"));
				$json[] = array(
						'ID' 	       => $data_product[$a]->ID,
						'name'       => $data_product[$a]->name,
						'count_category' => $count,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_product_category()
	{
		$ID = $this->input->get('ID');

		$data_product_category=$this->master_model->select_in('ms_product_category','*',"WHERE id_product = $ID ORDER BY name ASC");

		if(!empty($data_product_category))
		{
			for($a=0; $a < count($data_product_category); $a++)
			{
				$ID = $data_product_category[$a]->ID;
				$count = count($this->master_model->select_in('ms_product_subcategory','*',"WHERE id_product_category = $ID"));
				$json[] = array(
						'ID' 	       => $data_product_category[$a]->ID,
						'name'       => $data_product_category[$a]->name,
						'count_subcategory' => $count
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function search_master_product_category()
	{
		$param = $this->input->get('param');
		$id_product = $this->input->get('id_product');

		$data_product_category=$this->master_model->select_in('ms_product_category','*',"WHERE name LIKE '%$param%' AND id_product = $id_product ORDER BY name ASC");

		if(!empty($data_product_category))
		{
			for($a=0; $a < count($data_product_category); $a++)
			{
				$ID = $data_product_category[$a]->ID;
				$count = count($this->master_model->select_in('ms_product_subcategory','*',"WHERE id_product_category = $ID"));
				$json[] = array(
						'ID' 	       => $data_product_category[$a]->ID,
						'name'       => $data_product_category[$a]->name,
						'count_subcategory' => $count,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_product_subcategory()
	{
		$ID = $this->input->get('ID');

		$data_product_subcategory=$this->master_model->select_in('ms_product_subcategory','*',"WHERE id_product_category = $ID ORDER BY name ASC");

		if(!empty($data_product_subcategory))
		{
			for($a=0; $a < count($data_product_subcategory); $a++)
			{
				$ID = $data_product_subcategory[$a]->ID;
				$count = count($this->master_model->select_in('ms_product_spareparts','*',"WHERE id_product_subcategory = $ID"));
				$json[] = array(
						'ID' 	       => $data_product_subcategory[$a]->ID,
						'name'       => $data_product_subcategory[$a]->name,
						'count_sparepart' => $count
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_product_sparepart()
	{
		$ID = $this->input->get('ID');

		$data_product_sparepart=$this->master_model->select_in('ms_product_spareparts','*',"WHERE id_product_subcategory = $ID ORDER BY name ASC");

		if(!empty($data_product_sparepart))
		{
			for($a=0; $a < count($data_product_sparepart); $a++)
			{
				if($data_product_sparepart[$a]->image == '')
				{
					$image = base_url().'assets/img/default-50x50.gif';
				}else {
					$image = base_url().'uploads/product/'.$data_product_sparepart[$a]->image;
				}
				$json[] = array(
						'ID' 	       => $data_product_sparepart[$a]->ID,
						'name'       => $data_product_sparepart[$a]->name,
						'stock'      => $data_product_sparepart[$a]->stock,
						'price'      => str_replace(',','.', number_format($data_product_sparepart[$a]->price)),
						'image'      => $image,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function master_spareparts()
	{
		$data_spareparts=$this->master_model->select_in('ms_product_spareparts','*',"");

		if(!empty($data_spareparts))
		{
			for($a=0; $a < count($data_spareparts); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_spareparts[$a]->ID,
						'name'       => $data_spareparts[$a]->name,
						'barcode'    => $data_spareparts[$a]->barcode,
						'price'      => $data_spareparts[$a]->price,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function transaction_service()
	{
		$data_transaction = $this->master_model->select_in('ts_service','*',"ORDER BY ID DESC");

		if(!empty($data_transaction))
		{
			for($a=0; $a < count($data_transaction); $a++)
			{
				if($data_transaction[$a]->status == 0)
				{
					$status = 'Analys';//#00c0ef
				}elseif($data_transaction[$a]->status == 1)
				{
					$status = 'Process';
				}elseif($data_transaction[$a]->status == 2)
				{
					$status = 'Pending';
				}elseif($data_transaction[$a]->status == 3)
				{
					$status = 'Done';
				}elseif($data_transaction[$a]->status == 4)
				{
					$status = 'Failed';
				}

				$json[] = array(
						'ID' 	          => $data_transaction[$a]->ID,
						'invoice' 	    => $data_transaction[$a]->invoice,
						'product' 	    => $data_transaction[$a]->product,
						'date'          => date('d M Y', strtotime($data_transaction[$a]->date_in)),
						'grandtotal' 	  => str_replace(',','.', number_format($data_transaction[$a]->grandtotal)),
						'status'				=> $status
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function transaction_service_customer()
	{
		$ID = $this->input->get('ID');

		$data_transaction = $this->master_model->select_in('ts_service','*',"WHERE id_customer = $ID ORDER BY ID DESC");

		if(!empty($data_transaction))
		{
			for($a=0; $a < count($data_transaction); $a++)
			{
				if($data_transaction[$a]->status == 0)
				{
					$status = 'Analys';//#00c0ef
				}elseif($data_transaction[$a]->status == 1)
				{
					$status = 'Process';
				}elseif($data_transaction[$a]->status == 2)
				{
					$status = 'Pending';
				}elseif($data_transaction[$a]->status == 3)
				{
					$status = 'Done';
				}elseif($data_transaction[$a]->status == 4)
				{
					$status = 'Failed';
				}

				$json[] = array(
						'ID' 	          => $data_transaction[$a]->ID,
						'invoice' 	    => $data_transaction[$a]->invoice,
						'product' 	    => $data_transaction[$a]->product,
						'date'          => date('d M Y', strtotime($data_transaction[$a]->date_in)),
						'grandtotal' 	  => str_replace(',','.', number_format($data_transaction[$a]->grandtotal)),
						'status'				=> $status
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function transaction_jobs()
	{
		$data_transaction = $this->master_model->select_in('ts_service_detail a LEFT JOIN ts_service b ON a.id_service = b.ID','a.*, b.invoice',"ORDER BY a.ID DESC");

		if(!empty($data_transaction))
		{
			for($a=0; $a < count($data_transaction); $a++)
			{
				if($data_transaction[$a]->status == 0)
				{
					$status = 'Unprocess';//#00c0ef
				}elseif($data_transaction[$a]->status == 1)
				{
					$status = 'Process';
				}elseif($data_transaction[$a]->status == 2)
				{
					$status = 'Pending';
				}elseif($data_transaction[$a]->status == 3)
				{
					$status = 'Done';
				}elseif($data_transaction[$a]->status == 4)
				{
					$status = 'Failed';
				}

				$json[] = array(
						'ID' 	          => $data_transaction[$a]->ID,
						'id_service' 	  => $data_transaction[$a]->id_service,
						'invoice' 	    => $data_transaction[$a]->invoice,
						'jobs' 	        => $data_transaction[$a]->jobs,
						'subtotal' 	    => str_replace(',','.', number_format($data_transaction[$a]->subtotal)),
						'status'				=> $status
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function transaction_sparepart()
	{
		$data_transaction = $this->master_model->mst_data_spareparts();

		if(!empty($data_transaction))
		{
			for($a=0; $a < count($data_transaction); $a++)
			{
				if($data_transaction[$a]->status == 0)
				{
					$status = 'Unprocess';//#00c0ef
				}elseif($data_transaction[$a]->status == 1)
				{
					$status = 'Process';
				}elseif($data_transaction[$a]->status == 2)
				{
					$status = 'Pending';
				}elseif($data_transaction[$a]->status == 3)
				{
					$status = 'Done';
				}elseif($data_transaction[$a]->status == 4)
				{
					$status = 'Failed';
				}

				$json[] = array(
						'ID' 	          => $data_transaction[$a]->ID,
						'id_service' 	  => $data_transaction[$a]->id_service,
						'invoice' 	    => $data_transaction[$a]->invoice,
						'sparepart' 	  => $data_transaction[$a]->sparepart,
						'subtotal' 	    => str_replace(',','.', number_format($data_transaction[$a]->subtotal)),
						'status'				=> $status
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function invoice()
	{
		$ID = $this->input->get('ID');

		$data_transaction = $this->master_model->select_in('ts_service a LEFT JOIN ms_customer b ON a.id_customer = b.ID','a.*, b.name, b.phone, b.email, b.address',"WHERE a.ID=$ID");

		if(!empty($data_transaction))
		{
			if($data_transaction[0]->status == 0)
			{
				$status = 'Analys';//#00c0ef
			}elseif($data_transaction[0]->status == 1)
			{
				$status = 'Process';
			}elseif($data_transaction[0]->status == 2)
			{
				$status = 'Pending';
			}elseif($data_transaction[0]->status == 3)
			{
				$status = 'Done';
			}elseif($data_transaction[0]->status == 4)
			{
				$status = 'Failed';
			}

			$data_jobs = $this->master_model->select_in('ts_service_detail','ID, jobs, qty, price, subtotal',"WHERE id_service = $ID");
			for($a=0; $a < count($data_jobs); $a++)
			{
				$id_jobs = $data_jobs[$a]->ID;

				$data_spareparts = $this->master_model->select_in('ts_service_spareparts','ID, sparepart, qty, price, subtotal',"WHERE id_service_detail = $id_jobs");
				$spareparts = [];
				for($b=0; $b < count($data_spareparts); $b++)
				{
					$spareparts[] = array(
							'ID' 	          => $data_spareparts[$b]->ID,
							'sparepart' 	  => $data_spareparts[$b]->sparepart,
							'qty' 	        => $data_spareparts[$b]->qty,
							'price' 	      => str_replace(',','.', number_format($data_spareparts[$b]->price)),
							'subtotal'      => str_replace(',','.', number_format($data_spareparts[$b]->subtotal)),
					);
				}

				$jobs[] = array(
						'ID' 	          => $data_jobs[$a]->ID,
						'job' 	        => $data_jobs[$a]->jobs,
						'qty' 	        => $data_jobs[$a]->qty,
						'price' 	      => str_replace(',','.', number_format($data_jobs[$a]->price)),
						'subtotal'      => str_replace(',','.', number_format($data_jobs[$a]->subtotal)),
						'spareparts'     => $spareparts
				);
			}

			$total = $data_transaction[0]->total_service+$data_transaction[0]->total_parts;
			$total_tax = $total*$data_transaction[0]->tax/100;

			$json= array(
					'ID' 	          => $data_transaction[0]->ID,
					'invoice' 	    => $data_transaction[0]->invoice,
					'barcode'       => base_url().'master/create_barcode_code/'.$data_transaction[0]->invoice,
					'name_customer' => $data_transaction[0]->name,
					'phone_customer'=> $data_transaction[0]->phone,
					'email_customer'=> $data_transaction[0]->email,
					'address_customer' => $data_transaction[0]->address,
					'damage' 	      => $data_transaction[0]->damage,
					'product' 	    => $data_transaction[0]->product,
					'date'          => date('d M Y', strtotime($data_transaction[0]->date_in)),
					'tax' 	        => str_replace(',','.', number_format($data_transaction[0]->tax)),
					'total_tax' 	  => str_replace(',','.', number_format($total_tax)),
					'discount' 	    => str_replace(',','.', number_format($data_transaction[0]->discount)),
					'total' 	      => str_replace(',','.', number_format($data_transaction[0]->grandtotal+$data_transaction[0]->discount-$total_tax)),
					'grandtotal' 	  => str_replace(',','.', number_format($data_transaction[0]->grandtotal)),
					'status'				=> $status,
					'jobs'          => $jobs
			);
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function customer()
	{
		$ID = $this->input->get('ID');

		$data_customer = $this->master_model->select_in('ms_customer','*',"WHERE ID=$ID");

		if(!empty($data_customer))
		{

			$json= array(
					'ID' 	        => $data_customer[0]->ID,
					'name' 	      => $data_customer[0]->name,
					'phone'       => $data_customer[0]->phone,
					'email'       => $data_customer[0]->email,
					'address'     => $data_customer[0]->address,
			);
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function transaction_service_2()
	{
		$param = $this->input->get('param');

		$data_transaction = $this->master_model->select_in('ts_service','*',"WHERE status = $param ORDER BY ID DESC");

		if(!empty($data_transaction))
		{
			for($a=0; $a < count($data_transaction); $a++)
			{
				if($data_transaction[$a]->status == 0)
				{
					$status = 'Analys';//#00c0ef
				}elseif($data_transaction[$a]->status == 1)
				{
					$status = 'Process';
				}elseif($data_transaction[$a]->status == 2)
				{
					$status = 'Pending';
				}elseif($data_transaction[$a]->status == 3)
				{
					$status = 'Done';
				}elseif($data_transaction[$a]->status == 4)
				{
					$status = 'Failed';
				}

				$json[] = array(
						'ID' 	          => $data_transaction[$a]->ID,
						'invoice' 	    => $data_transaction[$a]->invoice,
						'product' 	    => $data_transaction[$a]->product,
						'date'          => date('d M Y', strtotime($data_transaction[$a]->date_in)),
						'grandtotal' 	  => str_replace(',','.', number_format($data_transaction[$a]->grandtotal)),
						'status'				=> $status
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function utility_group()
	{
		$data_group = $this->master_model->select_in('user_group', '*', "WHERE ID <> 1 ORDER BY name ASC");

    if(!empty($data_group))
		{
				for($a=0; $a < count($data_group); $a++)
				{
					$ID = $data_group[$a]->ID;

					$count = count($this->master_model->select_in('user', 'ID', "WHERE id_group = $ID"));
					$json[] = array(
							'ID' 	       => $data_group[$a]->ID,
	            'name' 	     => $data_group[$a]->name,
							'count_user' => $count
	        );
				}

		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function utility_group_detail()
	{
		$ID = $this->input->get('ID');

		$data_menu = $this->master_model->select_in('user_group_detail a LEFT JOIN ms_menu b ON a.id_menu = b.ID', 'a.ID, a.read_flg, b.name, b.ID AS id_menu', "WHERE a.id_group = $ID AND b.menu_level=1 ORDER BY b.sort ASC");

		$count=count($data_menu);

    if($count==0)
    {
        $json = array();
    }else
    {
        for($a=0; $a < count($data_menu); $a++)
        {
        	$id_menu = $data_menu[$a]->id_menu;

        	$check_sub_menu = $this->master_model->mst_check('ms_menu', 'parent_number', $id_menu);
        	if($check_sub_menu==false)
        	{
        		$sub_menu= array();
        	}else
        	{
        		$data_sub_menu = $this->master_model->select_in('user_group_detail a LEFT JOIN ms_menu b ON a.id_menu = b.ID', 'a.ID, a.read_flg, b.name, b.ID AS sub_id', "WHERE a.id_group = $ID AND b.parent_number = $id_menu AND b.menu_level = 2 AND b.publish=1 ORDER BY b.sort ASC");
						$sub_menu = [];
						for($b=0; $b < count($data_sub_menu); $b++)
						{
							if($data_sub_menu[$b]->read_flg == 0)
							{
								$subchecked = 'false';
							}else {
								$subchecked = 'true';
							}

							$sub_menu[]=array
							(
								'sub_id' 	      => $data_sub_menu[$b]->ID,
								'subtitle'      => $data_sub_menu[$b]->name,
								'checked'       => $subchecked
							);
						}
          }

					if($data_menu[$a]->read_flg == 0)
					{
						$checked = 'false';
					}else {
						$checked = 'true';
					}

          $json[] = array(
              'ID' 	       => $data_menu[$a]->ID,
              'title'      => $data_menu[$a]->name,
							'checked'    => $checked,
              'sub'        => $sub_menu
          );

        }
    }

		echo json_encode($json);
	}

	public function utility_user()
	{
		$ID = $this->input->get('ID');
		$data_user = $this->master_model->select_in('user', '*', "WHERE id_group = $ID ORDER BY name ASC");

    if(!empty($data_user))
		{
				for($a=0; $a < count($data_user); $a++)
				{
					$json[] = array(
							'ID' 	    => $data_user[$a]->ID,
	            'name' 	  => $data_user[$a]->name,
	        );
				}

		}else{
			$json = array();
		}

		echo json_encode($json);
	}


  public function menu()
	{
		$data_menu = $this->master_model->select_in('ms_menu', 'ID, name, component, icon_aps', "WHERE menu_level=1 AND publish=1 ORDER BY sort ASC");

    $count=count($data_menu);

    if($count==0)
    {
        $json = array();
    }else
    {
        for($a=0; $a < count($data_menu); $a++)
        {
        	$ID = $data_menu[$a]->ID;

        	$check_sub_menu = $this->master_model->mst_check('ms_menu', 'parent_number', $ID);
        	if($check_sub_menu==false)
        	{
        		$sub_menu= array();
        	}else
        	{
        		$data_sub_menu = $this->master_model->select_in('ms_menu', 'ID, name, component, icon_aps', "WHERE parent_number = $ID AND menu_level = 2 AND publish=1 ORDER BY sort ASC");
						$sub_menu = [];
						for($b=0; $b < count($data_sub_menu); $b++)
						{
							$sub_menu[]=array
							(
								'sub_id' 	      => $data_sub_menu[$b]->ID,
								'subtitle'      => $data_sub_menu[$b]->name,
								'subcomponent'  => $data_sub_menu[$b]->component,
								'subicon'       => $data_sub_menu[$b]->icon_aps
							);
						}
          }

          $json[] = array(
              'ID' 	       => $data_menu[$a]->ID,
              'title'      => $data_menu[$a]->name,
              'component'  => $data_menu[$a]->component,
              'icon'       => $data_menu[$a]->icon_aps,
              'sub'        => $sub_menu
          );

        }
    }

		// Print with json_encode()
		echo json_encode($json);
	}

	public function menu_access()
	{
		$id_admin = $this->input->get('id_admin');

		$get_id_group = $this->master_model->select_in('user', 'id_group', "WHERE ID =$id_admin");
		$id_group = $get_id_group[0]->id_group;

		$data_menu = $this->master_model->select_in('user_group_detail a LEFT JOIN ms_menu b ON a.id_menu = b.ID LEFT JOIN user c ON a.id_group = c.id_group', 'b.ID, b.name, b.component, b.icon_aps', "WHERE b.menu_level = 1 AND b.publish=1 AND c.ID = $id_admin AND a.read_flg = 1 ORDER BY b.sort ASC");

    $count=count($data_menu);

    if($count==0)
    {
        $json = array();
    }else
    {
        for($a=0; $a < count($data_menu); $a++)
        {
        	$ID = $data_menu[$a]->ID;

        	$check_sub_menu = $this->master_model->mst_check('ms_menu', 'parent_number', $ID);
        	if($check_sub_menu==false)
        	{
        		$sub_menu= array();
        	}else
        	{
        		$data_sub_menu = $this->master_model->select_in('user_group_detail a LEFT JOIN ms_menu b ON a.id_menu = b.ID LEFT JOIN user c ON a.id_group = c.id_group', 'b.ID, b.name, b.component, b.icon_aps', "WHERE b.parent_number = $ID AND b.menu_level = 2 AND b.publish = 1 AND c.ID = $id_admin AND a.read_flg = 1 ORDER BY b.sort ASC");
						$sub_menu = [];
						for($b=0; $b < count($data_sub_menu); $b++)
						{
							$sub_menu[]=array
							(
								'sub_id' 	      => $data_sub_menu[$b]->ID,
								'subtitle'      => $data_sub_menu[$b]->name,
								'subcomponent'  => $data_sub_menu[$b]->component,
								'subicon'       => $data_sub_menu[$b]->icon_aps
							);
						}
          }

          $json[] = array(
              'ID' 	       => $data_menu[$a]->ID,
              'title'      => $data_menu[$a]->name,
              'component'  => $data_menu[$a]->component,
              'icon'       => $data_menu[$a]->icon_aps,
              'sub'        => $sub_menu
          );

        }
    }

		// Print with json_encode()
		echo json_encode($json);
	}

	public function utility_menu()
	{
		$data_menu = $this->master_model->select_in('ms_menu', 'ID, name, publish', "WHERE menu_level=1 ORDER BY sort ASC");

    if(!empty($data_menu))
		{
				for($a=0; $a < count($data_menu); $a++)
				{
					$ID = $data_menu[$a]->ID;

					if($data_menu[$a]->publish == 0)
					{
						$checked = 'false';
					}else {
						$checked = 'true';
					}

					$count = count($this->master_model->select_in('ms_menu', 'ID', "WHERE parent_number = $ID AND menu_level = 2"));
					$json[] = array(
							'ID' 	          => $data_menu[$a]->ID,
	            'name' 	        => $data_menu[$a]->name,
							'count_submenu' => $count,
							'checked'				=> $checked
	        );
				}

		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function publish_menu()
	{
		$ID = $this->input->get('ID');
		$publish = $this->input->get('publish');

		if($publish == 'true')
		{
			$publish = 1;
		}else {
			$publish = 0;
		}
    $data_update=array(
			'publish' => $publish
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_menu', $data_update);

		$json= array(
				'status' 	=> 'success',
		);

		echo json_encode($json);
	}

	public function utility_submenu()
	{
		$ID = $this->input->get('ID');
		$data_menu = $this->master_model->select_in('ms_menu', 'ID, name, publish', "WHERE parent_number = $ID AND menu_level=2 ORDER BY sort ASC");

    if(!empty($data_menu))
		{
				for($a=0; $a < count($data_menu); $a++)
				{
					if($data_menu[$a]->publish == 0)
					{
						$checked = 'false';
					}else {
						$checked = 'true';
					}

					$json[] = array(
							'ID' 	          => $data_menu[$a]->ID,
	            'name' 	        => $data_menu[$a]->name,
							'checked' 	    => $checked,
	        );
				}

		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function notification_service()
	{
		$data_log_activity = $this->master_model->select_in('log_activity','*',"WHERE status_read = 0 AND activity <> 'Spareparts' ORDER BY ID DESC LIMIT 10");

		if(!empty($data_menu))
		{
				for($a=0; $a < count($data_menu); $a++)
				{
					if($data_menu[$a]->publish == 0)
					{
						$checked = 'false';
					}else {
						$checked = 'true';
					}

					$json[] = array(
							'ID' 	          => $data_menu[$a]->ID,
	            'name' 	        => $data_menu[$a]->name,
							'checked' 	    => $checked,
	        );
				}

		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function publish_submenu()
	{
		$ID = $this->input->get('ID');
		$publish = $this->input->get('publish');

		if($publish == 'true')
		{
			$publish = 1;
		}else {
			$publish = 0;
		}
    $data_update=array(
			'publish' => $publish
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_menu', $data_update);

		$json= array(
				'status' 	=> 'success',
		);

		echo json_encode($json);
	}


  public function login()
  {
      $postdata = file_get_contents("php://input");
      $request = json_decode($postdata);

      $username = $request->name;
      $password = $request->password;

      if($username=='' || $password=='')
      {
          $json= array(
              'ID' 	=> '',
              'name' 	=> '',
              'token' 	=> 'EmptyString',
          );
      }else
      {
          $password = md5(sha1($password));

          $check = $this->master_model->valid_user($username, $password);

          if($check == false)
          {
              $json= array(
                  'ID' 	=> '',
                  'name' 	=> '',
                  'token' 	=> 'No',
              );
          }else
          {
              $json= array(
                  'ID' 	    => $check[0]->ID,
                  'name' 	  => $check[0]->name,
                  'token' 	=> 'Yes',
              );
          }
	  	}

		echo json_encode($json);
	}

  public function register()
  {
      $postdata = file_get_contents("php://input");
      $request = json_decode($postdata);

      $username = $request->username;
      $email    = $request->email;
      $phone    = $request->phone;
      $address  = $request->address;

      if($username=='' || $email=='' || $phone=='' || $address=='')
      {
          $json= array(
              'ID' 	=> '',
              'name' 	=> '',
              'token' 	=> 'EmptyString',
          );
      }else
      {
          $check = $this->master_model->mst_check_3('ms_customer', "email=$email'");

          if($check == false)
          {
              $json= array(
                  'ID' 	=> '',
                  'name' 	=> '',
                  'token' 	=> 'Yes',
              );
          }else
          {
              $json= array(
                  'ID' 	=> $check[0]->ID,
                  'name' 	=> $check[0]->name,
                  'token' 	=> 'No',
              );
          }
      }

		echo json_encode($json);
	}

	function insert_group_process()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);

		$name     = $request->name;
		$menu     = $request->menu;

		$ID = $this->master_model->mst_last_id('user_group');
		$data = array
		(
			'ID'   => $ID,
			'name' => $name,
			'sort' => $ID,
		);
		$this->db->insert('user_group', $data);

		for($a=0; $a < count($menu); $a++)
		{
			$id_menu=$menu[$a]->ID;

			$checked = $menu[$a]->checked;
			if($checked == true)
			{
				$read_flg = 1;
			}else {
				$read_flg = 0;
			}

			$id_detail=$this->master_model->mst_last_id('user_group_detail');
			$data=array(
				'ID'      => $id_detail,
				'id_group'=> $ID,
				'id_menu' => $id_menu,
				'read_flg'=> $read_flg,
				'sort'    => $id_detail
			);
			$this->db->insert('user_group_detail', $data);


		}

		// for($b=0; $b < count($menu); $b++)
		// {
		// 	$this->set_checked($ID, $menu);
		// }

		$json= array(
				'status' 	=> 'success',
		);

		echo json_encode($json);
	}

	function set_checked($ID, $read_flg)
	{
		$strBaca = "";

		for ($i=0; $i < count($read_flg); $i++)
		{
			$strBaca = $strBaca."'".$read_flg[$i]."',";
		}

		$read_flg = substr($strBaca, 1, strlen($strBaca)-3);

		$this->master_model->update_user_group_detail($ID, $read_flg);
	}

	function insert_menu_process($menuid)
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);

		$name     = $request->name;
		$control  = $request->control;
		$icon     = $request->icon;

		$ID = $this->master_model->mst_last_id('ms_menu');
		$data = array
		(
			'ID'        => $ID,
			'name'      => $name,
			'component' => $control,
			'icon_aps'  => $icon,
			'sort'      => $ID,
		);
		$this->db->insert('ms_menu', $data);

		$data_group = $this->master_model->mst_data('user_group');
		for($a=0; $a < count($data_group); $a++)
		{
			if($data_group[$a]->ID == 1)
			{
				$read_flg = 1;
			}else {
				$read_flg = 0;
			}

			$id_group_detail = $this->master_model->mst_last_id('user_group_detail');
			$data_insert_group=array(
				'ID'       => $id_group_detail,
				'id_group' => $data_group[$a]->ID,
				'id_menu'  => $ID,
				'read_flg' => $read_flg,
				'sort'     => $id_group_detail
			);
			$thid->db->insert('user_group_detail', $data_insert_group);
		}

		$json= array(
				'status' 	=> 'success',
		);

		echo json_encode($json);
	}

	public function get_model()
	{
		$ID = $this->input->get('ID');

		//$get_id_product = $this->master_model->select_in('ms_product','ID',"WHERE name = '$name'");
		//$ID = $get_id_product[0]->ID;

		$data_model=$this->master_model->select_in('ms_product_category', 'ID, name', "WHERE id_product = $ID ORDER BY name ASC");

		if(!empty($data_model))
		{
			for($a=0; $a < count($data_model); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_model[$a]->ID,
						'name'       => $data_model[$a]->name,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	public function get_type()
	{
		$ID = $this->input->get('ID');

		//$get_id_category = $this->master_model->select_in('ms_product_category','ID',"WHERE name = '$name'");
		//$ID = $get_id_category[0]->ID;

		$data_type=$this->master_model->select_in('ms_product_subcategory', 'ID, name', "WHERE id_product_category = $ID ORDER BY name ASC");

		if(!empty($data_type))
		{
			for($a=0; $a < count($data_type); $a++)
			{
				$json[] = array(
						'ID' 	       => $data_type[$a]->ID,
						'name'       => $data_type[$a]->name,
				);
			}
		}else{
			$json = array();
		}

		echo json_encode($json);
	}

	function product_request()
	{
		$data_spareparts=$this->master_model->select_in('ts_service_spareparts a LEFT JOIN ms_product_spareparts b ON a.sparepart = b.name LEFT JOIN ms_product_subcategory c ON b.id_product_subcategory = c.ID LEFT JOIN ms_product_category d ON c.id_product_category = d.ID LEFT JOIN ms_product e ON d.id_product = e.id','SUM(a.qty) AS stock, b.ID AS id_spareparts, b.name, SUM(a.subtotal) AS price, c.name AS subcategory, d.name AS category, e.name AS product, e.ID AS id_product, d.ID AS id_product_category, c.ID AS id_product_subcategory',"WHERE a.status < 3 GROUP BY a.sparepart ORDER BY b.ID DESC");
	}

	function save_service()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);

		$customer     = $request->customer;
		$product      = $request->product;
		$jobs         = $request->jobs;

		$subtotal_job = $request->subtotal_service;
		$subtotal_sparepart = $request->subtotal_sparepart;
		$tax 					= $request->tax;
		$discount     = $request->discount;
		$grandtotal   = $request->grandtotal;

		$phone = $customer->phone;

		$check_customer=$this->master_model->mst_check('ms_customer', 'phone', $phone);

		if($check_customer==false)
		{
			$id_customer = $this->master_model->mst_last_id('ms_customer');
			$data_customer=array
			(
				'ID'           => $id_customer,
				'name'         => $customer->name,
				'email'        => $customer->email,
				'phone'        => $customer->phone,
				'address'      => $customer->address,
				'company'      => $customer->company,
				'company_phone'=> $customer->company_phone,
				'last_activity'=> date('Y-m-d'),
				'status'       => 0,
				'sort'         => $id_customer,
			);
			$this->db->insert('ms_customer', $data_customer);
		}else {
			$data_customer = $this->master_model->select_in('ms_customer', 'ID', "WHERE phone = '$phone'");
			$id_customer = $data_customer[0]->ID;

			$update_customer=array
			(
				'name'          => $customer->name,
				'company'       => $customer->company,
				'company_phone' => $customer->company_phone,
				'address'       => $customer->address,
				'last_activity' => date('Y-m-d'),
			);
			$this->db->where('ID', $id_customer);
			$this->db->update('ms_customer', $update_customer);
		}


		$ID=$this->master_model->mst_last_id('ts_service');
		$invoice=$this->master_model->create_invoice($ID);
		$data=array
		(
			'ID'           => $ID,
			'date_in'      => date('Y-m-d'),
			'invoice'      => $invoice,
			//'id_admin'     => $id_admin,
			'id_customer'  => $id_customer,
			//'product'      => $this->session->userdata('product').', '.$this->session->userdata('model').', '.$this->session->userdata('type').', '.$this->session->userdata('unit'),
			'damage'       => $product->damage,
			'total_service'=> $subtotal_job,
			'total_parts'  => 0,
			//'durations_day'=> $this->input->post('total_day'),
			'start_date'   => date('Y-m-d H:i:s'),
			//'finish_date'  => date('Y-m-d H:i:s', strtotime('+ '.$this->input->post('total_day').' Day', strtotime(date('Y-m-d H:i:s')))),
			'tax'          => $tax,
			'discount'     => $discount,
			'grandtotal'   => $grandtotal,
			'note'         => $product->note,
			'status'       => 0,
			'sort'         => $ID,
		);
		$this->db->insert('ts_service', $data);


		for($a=0; $a < count($jobs); $a++)
		{
			$id_detail=$this->master_model->mst_last_id('ts_service_detail');
			$data_detail=array
			(
				'ID'         => $id_detail,
				'id_service' => $ID,
				'jobs'       => $jobs[$a]->job,
				'technician' => $jobs[$a]->mechanic,
				'durations'  => $jobs[$a]->duration,
				//'pre_jobs'   => $id_pre,
				'qty'        => $jobs[$a]->qty,
				'price'      => $jobs[$a]->price,
			  'subtotal'   => $jobs[$a]->subtotal_job,
				'status'     => 0,
				'sort'       => $id_detail,
			);
			$this->db->insert('ts_service_detail', $data_detail);

			for($b=0; $b < count($jobs[$a]->spareparts); $b++)
			{
				if($jobs[$a]->spareparts[$b]->sparepart <> '')
				{
					$c = $b+1;

					//$count_spareparts = $c+1;

					$id_spareparts=$this->master_model->mst_last_id('ts_service_spareparts');
					$data_array_spareparts=array
					(
						'ID'=>$id_spareparts,
						'id_service_detail'=>$id_detail,
						'sparepart'=>$jobs[$a]->spareparts[$b]->sparepart,
						'qty'=>$jobs[$a]->spareparts[$b]->qty,
						'price'=>$jobs[$a]->spareparts[$b]->price,
						//'indent'=>$jobs[$a]->indent[$b],
						'order_date'=>date('Y-m-d'),
						'subtotal'=>str_replace('.','',$jobs[$a]->spareparts[$b]->subtotal_part),
						'sort'=>$id_spareparts,
					);
					$this->db->insert('ts_service_spareparts', $data_array_spareparts);
				}
			}
		}

		$json= array(
				'ID' 	=> $ID,
		);

		echo json_encode($json);
	}

	function check_menu_access($menuid, $id_user)
	{
		if($id_user == 1)
		{
			$sql = "SELECT a.read_flg, a.id_group, b.*
			FROM user_group_detail a
			LEFT JOIN user b ON a.id_group = b.id_group
			WHERE a.id_menu= $menuid";
			return true;
		}else
		{
			$sql = "SELECT a.read_flg, a.id_group, b.*
			FROM user_group_detail a
			LEFT JOIN user b ON a.id_group = b.id_group
			WHERE a.id_menu= $menuid AND b.ID = $id_user";
			$qry = $this->db->query($sql);
			$row = $qry->result();
			$access = $row[0]->read_flg;
			if($access == 0)
			{
				return false;
			}else{
				return true;
			}
		}
	}

}
