<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class master extends CI_Controller {

	public function __construct()
	{
		parent :: __construct();
		$this->load->model('master_model');
  }

	function create_barcode_code($code)
	{
		$this->load->library('zend');

		$this->zend->load('Zend/Barcode');

		Zend_Barcode::render('code128', 'image', array('text'=>$code), array());
	}

	public function customer($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_customer']    = $this->master_model->select_in('ms_customer','*',"ORDER BY ID DESC");

    		$this->load->view('customer/list', $data);
	    }
	}

	public function customer_detail($menuid, $id_customer)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_poin']    = $this->master_model->select_in('ms_customer_poin','*',"WHERE id_customer=$id_customer ORDER BY ID DESC");
			$this->load->view('customer/detail', $data);
	    }
	}

	public function insert_customer($menuid)
	{
		$submit = $this->input->post('submit');
		$id_customer = $this->master_model->mst_last_id('ms_customer');
		$admin = $this->session->userdata('username');
		$data = array
		(
			'ID' => $id_customer,
			'name' => $this->input->post('name'),
			'email' => $this->input->post('email'),
			'phone' => $this->input->post('phone'),
			'company' => $this->input->post('company'),
			'company_phone' => $this->input->post('company_phone'),
			'id_province' => $this->input->post('province'),
			'id_city' => $this->input->post('city'),
			'admin' => $admin,
			'address' => $this->input->post('address'),
			'status' => $this->input->post('status')
		);
		$this->db->insert('ms_customer', $data);
		if($submit==1)
		{
			redirect('master/customer/'.$menuid);
		}elseif($submit==2)
		{
			redirect('master/customer/'.$menuid);
		}elseif($submit==3)
		{
			redirect('transaction/start/37/'.$id_customer);
		}
	}

	public function delete_customer($menuid)
	{
		$ID = $this->input->post('ID');
		$check_customer = $this->master_model->mst_check('ts_service', 'id_customer', $ID);

		if($check_customer == false)
		{
			$this->db->where('ID', $ID);
			$this->db->delete('ms_customer');

			echo 'succesfully';
		}else {
			echo 'error';
		}
		//$this->db->where('id_customer', $ID);
		//$this->db->delete('ts_nota');


		//redirect('master/customer/'.$menuid);
	}


	public function edit_customer($menuid)
	{
		$id_customer = $this->input->post('ID');
		$data_edit = $this->master_model->mst_data_edit('ms_customer', $id_customer);

		echo'
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Edit Customer</h4>
		</div>
				<form action="'.base_url().'master/edit_process_customer/'.$menuid.'/'.$id_customer.'" method="post" enctype="multipart/form-data">
						<div class="modal-body">

								<div class="form-group">
										<label>Customer Name *</label>
										<input type="text" name="name" value="'.$data_edit[0]->name.'" class="form-control" placeholder="Customer Name" required="required">
								</div>
								<script type="text/javascript">
									$(document).ready(function()
									{
										exist2 = 0;
										$("#phone").change(function (e){
											var phone = $(this).val();
											 $("#phone-result").show();
											$.ajax({
												 type:"POST",
												 url: "'.base_url().'master/check_phone",
												 data:"phone="+phone,
												 success:function(msg)
												 {
													 if(msg == 1)
													 {
														 exist2 = 1;
														 $("#phone-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Phone number has been use!</font>");
													 }else{
														 exist2 = 0;
														 $("#phone-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i></font>");
													 }
												 }
											});
										});
										$("#save").click(function(){
											if(exist2 == 1)
											{
												alert("Phone number has been use!");
												return false;
											}else{
												return true;
											}
										});
									});
								</script>
								<div class="form-group">
										<label>Phone Number</label>
										<span id="phone-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
										<input type="text" name="phone" value="'.$data_edit[0]->phone.'" id="phone" class="form-control phone" placeholder="Phone">
								</div>
								<script type="text/javascript">
									$(document).ready(function()
									{
										exist2 = 0;
										$("#email").change(function (e){
											var email = $(this).val();
											$("#email-result").show();
											$.ajax({
												 type:"'.base_url().'>master/check_email",
												 data:"email="+email,
												 success:function(msg)
												 {
													 if(msg == 1)
													 {
														 exist2 = 1;
														 $("#email-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Email has been use!</font>");
													 }else{
														 exist2 = 0;
														 $("#email-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i></font>");
													 }
												 }
											});
										});
										$("#save").click(function(){
											if(exist2 == 1)
											{
												alert("Email has been use!");
												return false;
											}else{
												return true;
											}
										});
									});
								</script>
								<div class="form-group">
										<label>Email</label>
										<span id="email-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
										<input type="email" value="'.$data_edit[0]->email.'" name="email" id="email" class="form-control" placeholder="Email">
								</div>
								<div class="form-group">
										<label>Company</label>
										<input type="text" value="'.$data_edit[0]->company.'" name="company" class="form-control" placeholder="Company">
								</div>

								<div class="form-group">
										<label>Company Phone Number</label>
										<input type="text" value="'.$data_edit[0]->company_phone.'" name="company_phone" class="form-control" placeholder="Company Phone Number">
								</div>
								<div class="form-group">
										<label>Status</label>
										<br />
										<input type="radio" name="status" checked="checked" value="1"/> Verified
										<input type="radio" name="status" value="0"/> Unverified
								</div>
								<div class="form-group">
										<label>Address</label>
										<textarea name="address" class="form-control" placeholder="Address">'.$data_edit[0]->address.'</textarea>
								</div>
								<div class="form-group">
									<label>Province</label>
									<script>
										$(document).ready(function(e)
										{
											$(".province").change(function()
											{
												 var ID = $(this).val();

													$.ajax({
													 type: "POST",
													 dataType: "html",
													 url: "'.base_url().'master/get_city/'.$menuid.'",
													 data:"ID="+ID,
													 success: function(msg){
															$(".city").html(msg);
													 }
													});
											});
										});
									</script>
									<select name="province" class="province form-control">
										<option selected="selected" value="0">
											Choose Provincy
										</option>
										';
											$province = $data_edit[0]->id_province;
											$data_provincy = $this->master_model->select_in('ms_province','*',"ORDER BY name ASC");
											for($a=0; $a < count($data_provincy); $a++)
											{
												if($province == $data_provincy[$a]->ID)
												{
													$select = 'selected="selected"';
												}else {
													$select = '';
												}
												echo'
													<option value="'.$data_provincy[$a]->ID.'" '.$select.'>
														'.$data_provincy[$a]->name.'
													</option>
												';
											}
										echo'
									</select>
								</div>
								<div class="form-group">
									<label>City</label>
									<select name="city" class="city form-control">
										<option selected="selected" value="0">
											Choose City
										</option>
										';
											$city = $data_edit[0]->id_city;
											$data_city = $this->master_model->select_in('ms_city','*',"WHERE id_province = $province ORDER BY name ASC");
											for($a=0; $a < count($data_city); $a++)
											{
												if($city == $data_city[$a]->ID)
												{
													$selected = 'selected="selected"';
												}else {
													$selected = '';
												}
												echo'
													<option value="'.$data_city[$a]->ID.'" '.$selected.'>
														'.$data_city[$a]->name.'
													</option>
												';
											}
										echo'
									</select>
								</div>
								<div class="form-group">
										<label>Zip Code</label>
										<input type="text" name="zip" class="form-control" placeholder="Zip Code" value="'.$data_edit[0]->zip_code.'">
								</div>
						</div>
						<div class="modal-footer">
							<button type="submit" value="1" name="submit" class="btn btn-danger btn-fill pull-right save_phone save_email">Save And Close</button>
								<button type="submit" value="2" name="submit" class="btn btn-info btn-fill pull-right save_phone save_email" style="margin-right:5px;">Save and Add New</button>
								<button type="submit" value="3" name="submit" class="btn btn-success btn-fill pull-right save_phone save_email" style="margin-right:5px;">Save and Create Service</button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
				</form>
		';
	}


	public function edit_process_customer($menuid, $id_customer)
	{
		$submit=$this->input->post('submit');

		$data = array(
			'name' => $this->input->post('name'),
			'email' => $this->input->post('email'),
			'phone' => $this->input->post('phone'),
			'company' => $this->input->post('company'),
			'company_phone' => $this->input->post('company_phone'),
			'address' => $this->input->post('address'),
			'id_province' => $this->input->post('province'),
			'id_city' => $this->input->post('city'),
			'zip_code' => $this->input->post('zip'),
			'status' => $this->input->post('status')
		);
		$this->db->where('ID', $id_customer);
		$this->db->update('ms_customer', $data);
		if($submit==1)
		{
			redirect('master/customer/'.$menuid);
		}elseif($submit==2)
		{
			redirect('master/customer/'.$menuid);
		}elseif($submit==3)
		{
			redirect('transaction/start/27/'.$id_customer);
		}
	}






	public function product($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['ms_category'] = $this->master_model->select_in('ms_product','*',"ORDER BY name ASC");

			$this->load->view('master/product', $data);
	    }
	}



	public function insert_product($menuid)
	{
		$ID = $this->master_model->mst_last_id('ms_product');
		$data = array(
			'ID' => $ID,
			'name' => $this->input->post('name'),
			'note' => $this->input->post('desc'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_product', $data);
		redirect('master/product/'.$menuid);
	}

	public function edit_product($menuid)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_product', $ID);
		echo'
			<form method="post" action="'.base_url().'master/update_product/'.$menuid.'/'.$ID.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Product</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label>Name *</label>
						<input type="text" name="nama" class="form-control" placeholder="Name Category" required="required" value="'.$data_edit[0]->name.'">
					</div>
					<div class="form-group">
						<label>Description</label>
						<textarea name="description" class="form-control">'.$data_edit[0]->note.'</textarea>
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right cekKode" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function update_product($menuid, $ID)
	{
		$data=array
		(
			'name'=>$this->input->post('nama'),
			'note'=>$this->input->post('description'),
		);
		$this->db->where('ID',$ID);
		$this->db->update('ms_product', $data);

		redirect('master/product/'.$menuid);
	}


	public function delete_product($menuid, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_product');

		$this->db->where('id_product', $ID);
		$this->db->delete('ms_product_spareparts');

		redirect('master/product/'.$menuid);
	}



	public function category($menuid, $id_product)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['ms_category'] = $this->master_model->select_in('ms_product_category','*',"WHERE id_product = $id_product ORDER BY name ASC");

			$this->load->view('master/category', $data);
	    }
	}

	public function insert_category($menuid)
	{
		$id_product = $this->input->post('id_product');
		$ID = $this->master_model->mst_last_id('ms_product_category');
		$data = array(
			'ID' => $ID,
			'id_product' => $this->input->post('product'),
			'name' => $this->input->post('name'),
			'note' => $this->input->post('desc'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_product', $data);

		redirect('master/category/'.$menuid.'/'.$id_product);
	}


	public function edit_product_category($menuid, $id_product)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_product_category', $ID);

		echo'
			<form method="post" action="'.base_url().'master/update_product_category/'.$menuid.'/'.$ID.'/'.$id_product.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Product Category</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label>Name *</label>
						<input type="text" name="nama" class="form-control" placeholder="Name Category" required="required" value="'.$data_edit[0]->name.'">
					</div>

					<div class="form-group">
                        <label>Product *</label>
                        <select name="product" class="form-control">
                          ';
                            $data_product=$this->master_model->select_in('ms_product','*',"ORDER BY name ASC");

                            for($a=0; $a < count($data_product); $a++)
                            {
                              if($data_edit[0]->id_product == $data_product[$a]->ID)
                              {
                                $select = 'selected="selected"';
                              }else
                              {
                                $select = '';
                              }
                              echo'
                                <option value="'.$data_product[$a]->ID.'" '.$select.'>
                                  '.$data_product[$a]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>


					<div class="form-group">
						<label>Description</label>
						<textarea name="description" class="form-control">'.$data_edit[0]->note.'</textarea>
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right cekKode" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function update_product_category($menuid, $id_product, $ID)
	{
		$data=array
		(
			'name'=>$this->input->post('nama'),
			'id_product'=>$this->input->post('product'),
			'note'=>$this->input->post('description'),
		);
		$this->db->where('ID',$ID);
		$this->db->update('ms_product_category', $data);

		redirect('master/category/'.$menuid.'/'.$id_product);
	}


	public function delete_product_category($menuid, $id_product, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_product_category');

		$this->db->where('id_product_category', $ID);
		$this->db->delete('ms_product_subcategory');

		redirect('master/category/'.$menuid.'/'.$id_product);
	}


	public function subcategory($menuid, $id_product, $id_product_category)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['ms_category'] = $this->master_model->select_in('ms_product_subcategory','*',"WHERE id_product_category = $id_product_category ORDER BY name ASC");

			$this->load->view('master/subcategory', $data);
	    }
	}


	public function insert_subcategory($menuid)
	{
		$id_product = $this->input->post('id_product');
		$id_product_category = $this->input->post('id_product_category');

		$ID = $this->master_model->mst_last_id('ms_product_subcategory');
		$data = array(
			'ID' => $ID,
			'id_product_category' => $this->input->post('product_category'),
			'name' => $this->input->post('name'),
			'price' => $this->input->post('price'),
			'note' => $this->input->post('desc'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_product_category', $data);

		redirect('master/subcategory/'.$menuid.'/'.$id_product.'/'.$id_product_category);
	}


	public function edit_product_subcategory($menuid, $id_product, $id_product_category)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_product_subcategory', $ID);

		echo'
			<form method="post" action="'.base_url().'master/update_product_subcategory/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$ID.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Product Category</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label>Name *</label>
						<input type="text" name="nama" class="form-control" placeholder="Name Category" required="required" value="'.$data_edit[0]->name.'">
					</div>

					<div class="form-group">
                        <label>Price *</label>
                        <input type="text" name="price" class="form-control" placeholder="Price" required="required" value="'.$data_edit[0]->price.'">
                    </div>

					<div class="form-group">
                        <label>Product *</label>
                        <select name="product" class="form-control" disabled="disabled">
                          ';
                            $data_product=$this->master_model->select_in('ms_product','*',"ORDER BY name ASC");

                            for($a=0; $a < count($data_product); $a++)
                            {
                              if($data_edit[0]->id_product == $data_product[$a]->ID)
                              {
                                $select = 'selected="selected"';
                              }else
                              {
                                $select = '';
                              }
                              echo'
                                <option value="'.$data_product[$a]->ID.'" '.$select.'>
                                  '.$data_product[$a]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Category *</label>
                        <select name="product_category" class="form-control">
                          ';
                            $data_product_category=$this->master_model->select_in('ms_product_category','*',"WHERE id_product = $id_product ORDER BY name ASC");

                            for($b=0; $b < count($data_product_category); $b++)
                            {
                              if($id_product_category == $data_product_category[$b]->ID)
                              {
                                $selected = 'selected="selected"';
                              }else
                              {
                                $selected = '';
                              }
                              echo'
                                <option value="'.$data_product_category[$b]->ID.'" '.$selected.'>
                                  '.$data_product_category[$b]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>

					<div class="form-group">
						<label>Description</label>
						<textarea name="description" class="form-control">'.$data_edit[0]->note.'</textarea>
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right cekKode" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function update_product_subcategory($menuid, $id_product, $id_product_category, $ID)
	{
		$data=array
		(
			'name'=>$this->input->post('nama'),
			'price'=>$this->input->post('price'),
			'id_product_category'=>$this->input->post('product_category'),
			'note'=>$this->input->post('description'),
		);
		$this->db->where('ID',$ID);
		$this->db->update('ms_product_subcategory', $data);

		redirect('master/subcategory/'.$menuid.'/'.$id_product.'/'.$id_product_category);
	}


	public function delete_product_subcategory($menuid, $id_product, $id_product_category, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_product_subcategory');

		$this->db->where('id_product_subcategory', $ID);
		$this->db->delete('ms_product_spareparts');

		redirect('master/subcategory/'.$menuid.'/'.$id_product.'/'.$id_product_category);
	}


	public function spareparts($menuid, $id_product, $id_product_category, $id_product_subcategory)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['ms_brand'] = $this->master_model->select_in('ms_product_spareparts', '*', "WHERE id_product_subcategory=$id_product_subcategory");

	    	$data['data_unit'] = $this->master_model->select_in('ms_product_unit', '*', "WHERE id_product_subcategory=$id_product_subcategory");

			$this->load->view('master/spareparts', $data);
	    }
	}

	public function insert_spareparts($menuid, $id_product, $id_product_category, $id_product_subcategory)
	{
		$id_admin = $this->session->userdata('user_id');
		$ID = $this->master_model->mst_last_id('ms_product_spareparts');

		if($_FILES['ImageUpload']['name']=='')
		{
			$data = array(
				'ID' => $ID,
				'id_product_subcategory' => $this->input->post('subcategory'),
				'name' => $this->input->post('name'),
				'stock' => $this->input->post('stock'),
				'price' => $this->input->post('price'),
				'barcode' => $id_product.'-'.$id_product_category.'-'.$id_product_subcategory.'-'.$ID,
				'note' => $this->input->post('desc'),
				'sort' => $ID,
				'publish' => 1,
			);
			$this->db->insert('ms_product_spareparts', $data);
		}else
		{
			$Image 		= $ID.'.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);
			$Image_temp   = $ID.'_temp.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);

			$config['file_name']      = $ID.'_temp';
			$config['upload_path']    = './uploads/product/';
			$config['allowed_types']  = 'gif|jpg|png|';
			$config['max_size']	   = '2000';
			$config['max_width']      = '1500';
			$config['max_height']     = '1500';

			$this->upload->initialize($config);

			if(!$this->upload->do_upload('ImageUpload'))
			{
				$data = array('error' => $this->upload->display_errors('',''));
				$error = $data['error'];
				echo '<script language="javascript">alert("'.$error.'!");window.history.go(-1);</script>';
				exit();
			}else
			{
				$fileImage_temp 	= './uploads/product/'.$Image_temp;
				if (file_exists($fileImage_temp)){unlink($fileImage_temp);}
				$fileImage 	= './uploads/product/'.$Image;
				if (file_exists($fileImage) && $Image!= ''){unlink($fileImage);}
				$config['file_name']      = $ID;
				$this->upload->initialize($config);
				$this->upload->do_upload('ImageUpload');
			}

			$data = array(
				'ID' => $ID,
				'id_product_subcategory' => $this->input->post('subcategory'),
				'name' => $this->input->post('name'),
				'stock' => $this->input->post('stock'),
				'price' => $this->input->post('price'),
				'barcode' => $id_product.'-'.$id_product_category.'-'.$id_product_subcategory.'-'.$ID,
				'image' => $Image,
				'note' => $this->input->post('desc'),
				'sort' => $ID,
				'publish' => 1,
			);
			$this->db->insert('ms_product_spareparts', $data);
		}

		$id_log_spareparts = $this->master_model->mst_last_id('log_activity');
		$data_log_spareparts=array
		(
			'ID' => $id_log_spareparts,
			'activity' => 'Spareparts',
			'id_detail' => 0,
			'qty' => $this->input->post('stock'),
			'qty_in' => $this->input->post('stock'),
			'id_spareparts' => $ID,
			'id_admin' => $id_admin,
			'date_in' => date('Y-m-d H:i:s'),
			'status' => 1,
			'note' => 'Input First Stock',
			'sort' => $id_log_spareparts
		);
		$this->db->insert('log_activity', $data_log_spareparts);

		redirect('master/spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory);
	}

	public function selected_spareparts($menuid, $id_product, $id_product_category, $id_product_subcategory, $param)
	{
		$ID = $this->input->post('ID');

		if($param == 'search')
		{
			$ms_spareparts  = $this->master_model->select_in('ms_product_spareparts', '*', "WHERE barcode='$ID'");
		}else
		{
			$ms_spareparts  = $this->master_model->select_in('ms_product_spareparts', '*', "WHERE ID=$ID");
		}

		if(count($ms_spareparts) == 0)
		{
			echo 'error';
			exit;
		}else
		{
			$ID = $ms_spareparts[0]->ID;

			$name      = $ms_spareparts[0]->name;
			$note      = $ms_spareparts[0]->note;
			$stock     = $ms_spareparts[0]->stock;
			$request   = $ms_spareparts[0]->request;
			$price     = $ms_spareparts[0]->price;
			$image     = $ms_spareparts[0]->image;

			echo'
				<div class="box box-widget widget-user">
	        <div class="widget-user-header bg-aqua-active">
						<button type="button" class="close" data-dismiss="modal">&times;</button>
	          <h3 class="widget-user-username">
							<script>
								$(document).ready(function()
								{
									$(".history_spareparts").click(function()
									{
										 var ID = $(this).attr("alt");

											$.ajax({
											 type: "POST",
											 dataType: "html",
											 url: "'.base_url().'master/history_spareparts/'.$menuid.'",
											 data:"ID="+ID,
											 success: function(msg){
													$(".history-popup").html(msg);
											 }
											});
									});
								});
							</script>
							<a alt="'.$ID.'" class="history_spareparts" data-toggle="modal" data-target="#history-modal" style="color: #ffffff; cursor: pointer">
								'.$name.'
							</a>
						</h3>
						';
							$get_name_product = $this->master_model->select_in('ms_product', 'name', "WHERE ID = $id_product");
							$get_name_category = $this->master_model->select_in('ms_product_category', 'name', "WHERE ID = $id_product_category");
							$get_name_subcategory = $this->master_model->select_in('ms_product_subcategory', 'name', "WHERE ID = $id_product_subcategory");
						echo'
	          <h5 class="widget-user-desc">'.$get_name_product[0]->name.' - '.$get_name_category[0]->name.' - '.$get_name_subcategory[0]->name.'</h5>
	        </div>
	        <div class="widget-user-image">
						';
							if($image == '')
							{
								echo '<img class="img-circle" src="'.base_url().'assets/img/default-50x50.gif" alt="User Avatar">';
							}else {
								echo '<img class="img-circle" src="'.base_url().'uploads/product/'.$image.'" alt="User Avatar">';
							}
						echo'

	        </div>
	        <div class="box-footer">
	          <div class="row">
	            <div class="col-sm-4 border-right">
	              <div class="description-block">
	                <h5 class="description-header">
									<script src="'.base_url().'node_modules/socket.io/node_modules/socket.io-client/socket.io.js"></script>
									<script>
										$(document).ready(function()
										{
											$(".pencil").click(function()
											{
												var ID = $(this).attr("id");
												var name = $(this).attr("title");
												var value = $(this).attr("bug");

												alerty.prompt("Stock "+name,
													{
														inputType: "text",
														inputPlaceholder: "",
														inputValue: value
													},
													function(value)
													{
														var dataString =
														{
															value 	 : value,
														};

														$.ajax({
														 type: "POST",
														 dataType: "html",
														 url: "'.base_url().'master/update_stock/'.$menuid.'/"+ID,
														 data: dataString,
														 dataType: "json",
														 cache : false,
														 success: function(data)
														 {
																if(data.status == true)
																{
																	var socket = io.connect("http://"+window.location.hostname+":3000");

																	socket.emit("count_message_spareparts", {
																		count_message_spareparts: data.count_message_spareparts
																	});

																	socket.emit("new_notification_spareparts",
																	{
																		url_spareparts: data.url_spareparts,
																		name_spareparts: data.name_spareparts,
																		date_in_spareparts: data.date_in_spareparts,
																		admin_name_spareparts: data.admin_name_spareparts,
																		note_spareparts: data.note_spareparts,
																	});

																	alerty.alert("Succesfully "+data.note_spareparts);
																	$(".stock").html(value);

																} else if(data.status == false)
																{
																	alerty.toasts("Error", {place: "top"})
																}
														 }
														});
													},
													function(){alerty.toasts("Canceled")})
											});
										});
									</script>
									<span class="stock" style="font-size: 36px">
										'.$stock.'
									</span>
									<sub id="'.$ID.'" title="'.$name.'" bug="'.$stock.'" class="pencil text-blue" style="cursor: pointer">
										<i class="fa fa-pencil"></i>
									</sub>
									</h5>
	                <span class="description-text">STOCK</span>
	              </div>
	            </div>
	            <div class="col-sm-4 border-right">
	              <div class="description-block">
	                <h5 class="description-header">
										<script>
											$(".request").click(function()
											{
												 var spareparts = $(this).attr("alt");

													$.ajax({
													 type: "POST",
													 dataType: "html",
													 url: "'.base_url().'master/spareparts_request/'.$menuid.'",
													 data:"spareparts="+spareparts,
													 success: function(msg){
															$(".request-popup").html(msg);
													 }
													});
											});
										</script>
										<a alt="'.$name.'" class="request" data-toggle="modal" data-target="#request-modal" style="cursor: pointer; font-size: 36px">
											'.$request.'
										</a>
										<input type="hidden" class="request" value="'.$request.'">
									</h5>
	                <span class="description-text">REQUEST</span>
	              </div>
	            </div>
	            <div class="col-sm-4">
	              <div class="description-block">
	                <h5 class="description-header">
										<script>
											$(document).ready(function()
											{
												$(".pencil-price").click(function()
												{
													var name = $(this).attr("alt");
													var value = $(this).attr("bug");

													alerty.prompt("Price "+name,
														{
															inputType: "text",
															inputPlaceholder: "",
															inputValue: value
														},
														function(value)
														{
															var dataString =
															{
																value 	 : value,
															};

															$.ajax({
															 type: "POST",
															 dataType: "html",
															 url: "'.base_url().'master/update_price/'.$menuid.'/'.$ID.'",
															 data: dataString,
															 dataType: "json",
															 cache : false,
															 success: function(data)
															 {
																	if(data.status == true)
																	{
																		var socket = io.connect("http://"+window.location.hostname+":3000");

																		socket.emit("count_message_spareparts", {
																			count_message_spareparts: data.count_message_spareparts
																		});

																		socket.emit("new_notification_spareparts",
																		{
																			url_spareparts: data.url_spareparts,
																			name_spareparts: data.name_spareparts,
																			date_in_spareparts: data.date_in_spareparts,
																			admin_name_spareparts: data.admin_name_spareparts,
																			note_spareparts: data.note_spareparts,
																		});

																		alerty.alert("Succesfully "+data.note_spareparts);
																		$(".price").html(value);

																	} else if(data.status == false)
																	{
																		alerty.toasts("Error", {place: "top"})
																	}
															 }
															});
														},
														function(){alerty.toasts("Canceled")})
												});
											});
										</script>

										<span alt="'.$name.'" class="price" style="cursor: pointer; font-size: 36px" bug="'.$price.'">
											'.str_replace(',','.', number_format($price)).'
										</span>
										<sub alt="'.$name.'" bug="'.$price.'" class="pencil-price text-blue" style="cursor: pointer">
											<i class="fa fa-pencil"></i>
										</sub>
									</h5>
	                <span class="description-text">PRICE</span>
	              </div>
	            </div>
	          </div>
	        </div>

					';
					$data_history = $this->master_model->select_in('log_activity','*',"WHERE activity = 'Spareparts' AND status < 2 AND id_detail = 0 AND id_spareparts = $ID ORDER BY date_in DESC");
					$count = count($data_history);
					echo'
					<div class="col-md-12">
					<table id="example1" class="table table-bordered table-striped">
							<thead>
									<tr>
											<th>No.</th>
											<th>In</th>
											<th>Out</th>
											<th>Stock</th>
											<th>Date</th>
											<th>Note</th>
											<th>Admin</th>
									</tr>
							</thead>
							<tbody>
									';
										if($count == 0)
										{
											echo'
												<tr>
													<td colspan="6">
														No data history available
													</td>
												</tr>
											';
										}else {
										$data_first = $this->master_model->select_in('log_activity', 'qty_in', "WHERE activity = 'Spareparts' AND status < 2 AND id_detail = 0 AND id_spareparts = $ID AND note = 'Input first stock'");
										$first_stock = $data_first[0]->qty_in;
										$stock = 0;
										for($a=0; $a < count($data_history); $a++)
										{
											$b = $a+1;

											$id_admin = $data_history[$a]->id_admin;
											$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");

											$qty_in = $data_history[$a]->qty_in;
											$qty_out = $data_history[$a]->qty_out;

											echo'
												<tr>
													<td>'.$b.'</td>
													';
														echo'
															<td>'.$data_history[$a]->qty_in.'</td>
															<td>'.$data_history[$a]->qty_out.'</td>
														';
													 echo'
													<td>
														'.$data_history[$a]->qty.'
													</td>
													<td>'.date('d M Y H:i', strtotime($data_history[$a]->date_in)).'</td>
													<td>'.$data_history[$a]->note.'</td>
													<td>'.$data_admin[0]->name.'</td>
												</tr>
											';

										}
									}
									echo'
							</tbody>
				  </table>
					</div>
					<div style="clear: both"></div>
	      </div>
			';
		}
	}



	public function selected_spareparts_2($menuid)
	{
		$barcode = $this->input->post('barcode');

		$ms_spareparts  = $this->master_model->select_in('ms_product_spareparts', '*', "WHERE barcode='$barcode'");



		if(count($ms_spareparts) == 0)
		{
			echo 'error';
			//exit;
		}else
		{
			$ID        = $ms_spareparts[0]->ID;
			$id_product_subcategory = $ms_spareparts[0]->id_product_subcategory;
			$name      = $ms_spareparts[0]->name;
			$note      = $ms_spareparts[0]->note;
			$stock     = $ms_spareparts[0]->stock;
			$request   = $ms_spareparts[0]->request;
			$price     = $ms_spareparts[0]->price;
			$image     = $ms_spareparts[0]->image;

			$get_id_category = $this->master_model->select_in('ms_product_subcategory','id_product_category',"WHERE ID = $id_product_subcategory");
			$id_product_category = $get_id_category[0]->id_product_category;

			$get_id_product = $this->master_model->select_in('ms_product_category','id_product',"WHERE ID = $id_product_category");
			$id_product = $get_id_product[0]->id_product;

			echo'
				<div class="box box-widget widget-user">
	        <div class="widget-user-header bg-aqua-active">
						<button type="button" class="close" data-dismiss="modal">&times;</button>
	          <h3 class="widget-user-username">
							<script>
								$(document).ready(function()
								{
									$(".history_spareparts").click(function()
									{
										 var ID = $(this).attr("alt");

											$.ajax({
											 type: "POST",
											 dataType: "html",
											 url: "'.base_url().'master/history_spareparts/'.$menuid.'",
											 data:"ID="+ID,
											 success: function(msg){
													$(".history-popup").html(msg);
											 }
											});
									});
								});
							</script>
							<a alt="'.$ID.'" class="history_spareparts" data-toggle="modal" data-target="#history-modal" style="color: #ffffff; cursor: pointer">
								'.$name.'
							</a>
						</h3>
						';
							$get_name_product = $this->master_model->select_in('ms_product', 'name', "WHERE ID = $id_product");
							$get_name_category = $this->master_model->select_in('ms_product_category', 'name', "WHERE ID = $id_product_category");
							$get_name_subcategory = $this->master_model->select_in('ms_product_subcategory', 'name', "WHERE ID = $id_product_subcategory");
						echo'
	          <h5 class="widget-user-desc">'.$get_name_product[0]->name.' - '.$get_name_category[0]->name.' - '.$get_name_subcategory[0]->name.'</h5>
	        </div>
	        <div class="widget-user-image">
						';
							if($image == '')
							{
								echo '<img class="img-circle" src="'.base_url().'assets/img/default-50x50.gif" alt="User Avatar">';
							}else {
								echo '<img class="img-circle" src="'.base_url().'uploads/product/'.$image.'" alt="User Avatar">';
							}
						echo'

	        </div>
	        <div class="box-footer">
	          <div class="row">
	            <div class="col-sm-4 border-right">
	              <div class="description-block">
	                <h5 class="description-header">
									<script src="'.base_url().'node_modules/socket.io/node_modules/socket.io-client/socket.io.js"></script>
									<script>
										$(document).ready(function()
										{
											$(".pencil").click(function()
											{
												var ID = $(this).attr("id");
												var name = $(this).attr("title");
												var value = $(this).attr("bug");

												alerty.prompt("Stock "+name,
													{
														inputType: "text",
														inputPlaceholder: "",
														inputValue: value
													},
													function(value)
													{
														var dataString =
														{
															value 	 : value,
														};

														$.ajax({
														 type: "POST",
														 dataType: "html",
														 url: "'.base_url().'master/update_stock/'.$menuid.'/"+ID,
														 data: dataString,
														 dataType: "json",
														 cache : false,
														 success: function(data)
														 {
																if(data.status == true)
																{
																	var socket = io.connect("http://"+window.location.hostname+":3000");

																	socket.emit("count_message_spareparts", {
																		count_message_spareparts: data.count_message_spareparts
																	});

																	socket.emit("new_notification_spareparts",
																	{
																		url_spareparts: data.url_spareparts,
																		name_spareparts: data.name_spareparts,
																		date_in_spareparts: data.date_in_spareparts,
																		admin_name_spareparts: data.admin_name_spareparts,
																		note_spareparts: data.note_spareparts,
																	});

																	alerty.alert("Succesfully "+data.note_spareparts);
																	$(".stock").html(value);

																} else if(data.status == false)
																{
																	alerty.toasts("Error", {place: "top"})
																}
														 }
														});
													},
													function(){alerty.toasts("Canceled")})
											});
										});
									</script>
									<span class="stock" style="font-size: 36px">
										'.$stock.'
									</span>
									<sub id="'.$ID.'" title="'.$name.'" bug="'.$stock.'" class="pencil text-blue" style="cursor: pointer">
										<i class="fa fa-pencil"></i>
									</sub>
									</h5>
	                <span class="description-text">STOCK</span>
	              </div>
	            </div>
	            <div class="col-sm-4 border-right">
	              <div class="description-block">
	                <h5 class="description-header">
										<script>
											$(".request").click(function()
											{
												 var spareparts = $(this).attr("alt");

													$.ajax({
													 type: "POST",
													 dataType: "html",
													 url: "'.base_url().'master/spareparts_request/'.$menuid.'",
													 data:"spareparts="+spareparts,
													 success: function(msg){
															$(".request-popup").html(msg);
													 }
													});
											});
										</script>
										<a alt="'.$name.'" class="request" data-toggle="modal" data-target="#request-modal" style="cursor: pointer; font-size: 36px">
											'.$request.'
										</a>
										<input type="hidden" class="request" value="'.$request.'">
									</h5>
	                <span class="description-text">REQUEST</span>
	              </div>
	            </div>
	            <div class="col-sm-4">
	              <div class="description-block">
	                <h5 class="description-header">
										<script>
											$(document).ready(function()
											{
												$(".pencil-price").click(function()
												{
													var name = $(this).attr("alt");
													var value = $(this).attr("bug");

													alerty.prompt("Price "+name,
														{
															inputType: "text",
															inputPlaceholder: "",
															inputValue: value
														},
														function(value)
														{
															var dataString =
															{
																value 	 : value,
															};

															$.ajax({
															 type: "POST",
															 dataType: "html",
															 url: "'.base_url().'master/update_price/'.$menuid.'/'.$ID.'",
															 data: dataString,
															 dataType: "json",
															 cache : false,
															 success: function(data)
															 {
																	if(data.status == true)
																	{
																		var socket = io.connect("http://"+window.location.hostname+":3000");

																		socket.emit("count_message_spareparts", {
																			count_message_spareparts: data.count_message_spareparts
																		});

																		socket.emit("new_notification_spareparts",
																		{
																			url_spareparts: data.url_spareparts,
																			name_spareparts: data.name_spareparts,
																			date_in_spareparts: data.date_in_spareparts,
																			admin_name_spareparts: data.admin_name_spareparts,
																			note_spareparts: data.note_spareparts,
																		});

																		alerty.alert("Succesfully "+data.note_spareparts);
																		$(".price").html(value);

																	} else if(data.status == false)
																	{
																		alerty.toasts("Error", {place: "top"})
																	}
															 }
															});
														},
														function(){alerty.toasts("Canceled")})
												});
											});
										</script>

										<span alt="'.$name.'" class="price" style="cursor: pointer; font-size: 36px" bug="'.$price.'">
											'.str_replace(',','.', number_format($price)).'
										</span>
										<sub alt="'.$name.'" bug="'.$price.'" class="pencil-price text-blue" style="cursor: pointer">
											<i class="fa fa-pencil"></i>
										</sub>
									</h5>
	                <span class="description-text">PRICE</span>
	              </div>
	            </div>
	          </div>
	        </div>

					';
					$data_history = $this->master_model->select_in('log_activity','*',"WHERE activity = 'Spareparts' AND status < 2 AND id_detail = 0 AND id_spareparts = $ID ORDER BY date_in DESC");
					$count = count($data_history);
					echo'
					<div class="col-md-12">
					<table id="example1" class="table table-bordered table-striped">
							<thead>
									<tr>
											<th>No.</th>
											<th>In</th>
											<th>Out</th>
											<th>Stock</th>
											<th>Date</th>
											<th>Note</th>
											<th>Admin</th>
									</tr>
							</thead>
							<tbody>
									';
										if($count == 0)
										{
											echo'
												<tr>
													<td colspan="6">
														No data history available
													</td>
												</tr>
											';
										}else {
										$data_first = $this->master_model->select_in('log_activity', 'qty_in', "WHERE activity = 'Spareparts' AND status < 2 AND id_detail = 0 AND id_spareparts = $ID AND note = 'Input first stock'");
										$first_stock = $data_first[0]->qty_in;
										$stock = 0;
										for($a=0; $a < count($data_history); $a++)
										{
											$b = $a+1;

											$id_admin = $data_history[$a]->id_admin;
											$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");

											$qty_in = $data_history[$a]->qty_in;
											$qty_out = $data_history[$a]->qty_out;

											echo'
												<tr>
													<td>'.$b.'</td>
													';
														echo'
															<td>'.$data_history[$a]->qty_in.'</td>
															<td>'.$data_history[$a]->qty_out.'</td>
														';
													 echo'
													<td>
														'.$data_history[$a]->qty.'
													</td>
													<td>'.date('d M Y H:i', strtotime($data_history[$a]->date_in)).'</td>
													<td>'.$data_history[$a]->note.'</td>
													<td>'.$data_admin[0]->name.'</td>
												</tr>
											';

										}
									}
									echo'
							</tbody>
				  </table>
					</div>
					<div style="clear: both"></div>
	      </div>
			';
		}
	}


	public function insert_units($menuid, $id_product, $id_product_category, $id_product_subcategory)
	{
		$ID = $this->master_model->mst_last_id('ms_product_unit');
		$data = array(
			'ID' => $ID,
			'id_product_subcategory' => $this->input->post('subcategory'),
			'policy_number' => $this->input->post('name'),
			'note' => $this->input->post('desc'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_product_unit', $data);
		redirect('master/spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory);
	}


	public function edit_spareparts($menuid, $id_product, $id_product_category, $id_product_subcategory)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_product_spareparts', $ID);

		echo'
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Add New Spareparts</h4>
            </div>
            <form method="post" action="'.base_url().'master/update_spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory.'/'.$ID.'" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Name *</label>
                        <input type="text" name="name" class="form-control" placeholder="Spareparts" required="required" value="'.$data_edit[0]->name.'">
                    </div>
                    <div class="form-group">
                        <label>Product</label>
                        <select name="product" required class="form-control" disabled="disabled">
                        	';
								$data_category=$this->master_model->select_in('ms_product','ID, name',"ORDER BY name ASC");

								for($a=0; $a < count($data_category); $a++)
								{
									if($id_product==$data_category[$a]->ID)
									{
										$select='selected="selected"';
									}else
									{
										$select='';
									}
									echo'
										<option value="'.$data_category[$a]->ID.'" '.$select.'>
											'.$data_category[$a]->name.'
										</option>
									';
								}
							echo'
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Category</label>
                        <select name="category" required class="form-control" disabled="disabled">
                          ';
                            $data_product_category=$this->master_model->select_in('ms_product_category','ID, name',"ORDER BY name ASC");

                            for($b=0; $b < count($data_product_category); $b++)
                            {
                              if($id_product_category==$data_product_category[$b]->ID)
                              {
                                $selected='selected="selected"';
                              }else
                              {
                                $selected='';
                              }
                              echo'
                                <option value="'.$data_product_category[$b]->ID.'" '.$selected.'>
                                  '.$data_product_category[$b]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>


                    <div class="form-group">
                        <label>Subcategory</label>
                        <select name="subcategory" required class="form-control">
                          ';
                            $data_product_subcategory=$this->master_model->select_in('ms_product_subcategory','ID, name',"WHERE id_product_category = $id_product_category ORDER BY name ASC");

                            for($c=0; $c < count($data_product_subcategory); $c++)
                            {
                              if($id_product_subcategory==$data_product_subcategory[$c]->ID)
                              {
                                $selecteds='selected="selected"';
                              }else
                              {
                                $selecteds='';
                              }
                              echo'
                                <option value="'.$data_product_subcategory[$c]->ID.'" '.$selecteds.'>
                                  '.$data_product_subcategory[$c]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Stock</label>
                        <input type="number" name="stock" class="form-control" placeholder="Qty" value="'.$data_edit[0]->stock.'">
                    </div>

                    <div class="form-group">
                        <label>Price</label>
                        <input type="text" name="price" class="form-control" placeholder="Price" value="'.$data_edit[0]->price.'">
                    </div>

										<div class="form-group">
											<label>Image</label>
											<br>
											';
												if($data_edit[0]->image <> '')
												{
													echo '<img src="'.base_url().'uploads/product/'.$data_edit[0]->image.'" width="100">';
												}
											echo'
											<input type="file" name="ImageUpload">
										</div>

                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="desc" class="form-control" placeholder="Description">'.$data_edit[0]->note.'</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
                    <button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px">Close</button>
                </div>
            </form>
		';
	}


	public function edit_units($menuid, $id_product, $id_product_category, $id_product_subcategory)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_product_unit', $ID);

		echo'
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Add New Spareparts</h4>
            </div>
            <form method="post" action="'.base_url().'master/update_units/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory.'/'.$ID.'">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Policy Number *</label>
                        <input type="text" name="name" class="form-control" placeholder="Policy Number" required="required" value="'.$data_edit[0]->policy_number.'">
                    </div>
                    <div class="form-group">
                        <label>Product</label>
                        <select name="product" required class="form-control" disabled="disabled">
                        	';
								$data_category=$this->master_model->select_in('ms_product','ID, name',"ORDER BY name ASC");

								for($a=0; $a < count($data_category); $a++)
								{
									if($id_product==$data_category[$a]->ID)
									{
										$select='selected="selected"';
									}else
									{
										$select='';
									}
									echo'
										<option value="'.$data_category[$a]->ID.'" '.$select.'>
											'.$data_category[$a]->name.'
										</option>
									';
								}
							echo'
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Category</label>
                        <select name="category" required class="form-control" disabled="disabled">
                          ';
                            $data_product_category=$this->master_model->select_in('ms_product_category','ID, name',"ORDER BY name ASC");

                            for($b=0; $b < count($data_product_category); $b++)
                            {
                              if($id_product_category==$data_product_category[$b]->ID)
                              {
                                $selected='selected="selected"';
                              }else
                              {
                                $selected='';
                              }
                              echo'
                                <option value="'.$data_product_category[$b]->ID.'" '.$selected.'>
                                  '.$data_product_category[$b]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>


                    <div class="form-group">
                        <label>Subcategory</label>
                        <select name="subcategory" required class="form-control">
                          ';
                            $data_product_subcategory=$this->master_model->select_in('ms_product_subcategory','ID, name',"WHERE id_product_category = $id_product_category ORDER BY name ASC");

                            for($c=0; $c < count($data_product_subcategory); $c++)
                            {
                              if($id_product_subcategory==$data_product_subcategory[$c]->ID)
                              {
                                $selecteds='selected="selected"';
                              }else
                              {
                                $selecteds='';
                              }
                              echo'
                                <option value="'.$data_product_subcategory[$c]->ID.'" '.$selecteds.'>
                                  '.$data_product_subcategory[$c]->name.'
                                </option>
                              ';
                            }
                          echo'
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="desc" class="form-control" placeholder="Description">'.$data_edit[0]->note.'</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
                    <button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px">Close</button>
                </div>
            </form>
		';
	}

	public function update_spareparts($menuid, $id_product, $id_product_category, $id_product_subcategory, $ID)
	{
		$id_product_subcategory = $this->input->post('subcategory');

		if($_FILES['ImageUpload']['name']=='')
		{
			$data = array(
				'id_product_subcategory' => $this->input->post('subcategory'),
				'name' => $this->input->post('name'),
				'stock' => $this->input->post('stock'),
				'price' => $this->input->post('price'),
				'barcode' => $id_product.'-'.$id_product_category.'-'.$id_product_subcategory.'-'.$ID,
				'note' => $this->input->post('desc'),
			);
			$this->db->where('ID', $ID);
			$this->db->update('ms_product_spareparts', $data);
		}else
		{
			$Image 		= $ID.'.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);
			$Image_temp   = $ID.'_temp.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);

			$config['file_name']      = $ID.'_temp';
			$config['upload_path']    = './uploads/product/';
			$config['allowed_types']  = 'gif|jpg|png|';
			$config['max_size']	   = '2000';
			$config['max_width']      = '1500';
			$config['max_height']     = '1500';

			$this->upload->initialize($config);

			if(!$this->upload->do_upload('ImageUpload'))
			{
				$data = array('error' => $this->upload->display_errors('',''));
				$error = $data['error'];
				echo '<script language="javascript">alert("'.$error.'!");window.history.go(-1);</script>';
				exit();
			}else
			{
				$fileImage_temp 	= './uploads/product/'.$Image_temp;
				if (file_exists($fileImage_temp)){unlink($fileImage_temp);}
				$fileImage 	= './uploads/product/'.$Image;
				if (file_exists($fileImage) && $Image!= ''){unlink($fileImage);}
				$config['file_name']      = $ID;
				$this->upload->initialize($config);
				$this->upload->do_upload('ImageUpload');
			}

			$data = array(
				'id_product_subcategory' => $this->input->post('subcategory'),
				'name' => $this->input->post('name'),
				'stock' => $this->input->post('stock'),
				'price' => $this->input->post('price'),
				'barcode' => $id_product.'-'.$id_product_category.'-'.$id_product_subcategory.'-'.$ID,
				'image' => $Image,
				'note' => $this->input->post('desc'),
			);
			$this->db->where('ID', $ID);
			$this->db->update('ms_product_spareparts', $data);
		}

		redirect('master/spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory);
	}

	public function update_units($menuid, $id_product, $id_product_category, $id_product_subcategory, $ID)
	{
		$id_product_subcategory = $this->input->post('subcategory');
		$data = array(
			'id_product_subcategory' => $this->input->post('subcategory'),
			'policy_number' => $this->input->post('name'),
			'note' => $this->input->post('desc'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_product_unit', $data);

		redirect('master/spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory);
	}


	public function delete_spareparts($menuid, $id_product, $id_product_category, $id_product_subcategory, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_product_spareparts');

		redirect('master/spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory);
	}

	public function delete_units($menuid, $id_product, $id_product_category, $id_product_subcategory, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_product_unit');

		redirect('master/spareparts/'.$menuid.'/'.$id_product.'/'.$id_product_category.'/'.$id_product_subcategory);
	}



	public function delete_brand($menuid, $id_category, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_brand');

		$this->db->where('id_brand', $ID);
		$this->db->delete('ms_model');

		redirect('admin/master/brand/'.$menuid.'/'.$id_category);
	}





	public function account($menuid)
	{
		$user_id = $this->session->userdata('user_id');
    $check=$this->master_model->auth_read($user_id, $menuid);

    if($check==false)
    {
        redirect('NotAuthorized');
    }else
    {
			$data['ms_account'] = $this->master_model->mst_data('ms_account');

			$this->load->view('account/main', $data);
    }


	}

	public function insert_account($menuid)
	{
		$ID = $this->master_model->mst_last_id('ms_account');
		$data = array(
			'ID' => $ID,
			'name' => $this->input->post('name'),
			'input_1' => $this->input->post('input_1'),
			'input_2' => $this->input->post('input_2'),
			'input_3' => $this->input->post('input_3'),
			'note' => $this->input->post('note'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_account', $data);
		redirect('master/account/'.$menuid);
	}



	public function edit_brand($menuid, $id_category)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_brand',$ID);
		echo'
			<form method="post" action="'.base_url().'admin/master/update_brand/'.$menuid.'/'.$id_category.'/'.$ID.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Brand</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label>Nama Brand *</label>
						<input type="text" name="nama" class="form-control" placeholder="Name Category" required="required" value="'.$data_edit[0]->name.'">
					</div>

					<div class="form-group">
						<label>Category *</label>
						<select name="category" required class="form-control">
							';
								$data_category=$this->master_model->select_in('ms_category','ID, name',"ORDER BY name ASC");

								for($a=0; $a < count($data_category); $a++)
								{
									if($data_edit[0]->id_category==$data_category[$a]->ID)
									{
										$select='selected="selected"';
									}else
									{
										$select='';
									}
									echo'
										<option value="'.$data_category[$a]->ID.'" '.$select.'>
											'.$data_category[$a]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>
					<div class="form-group">
						<label>Deskripsi</label>
						<textarea name="description" class="form-control">'.$data_edit[0]->desc.'</textarea>
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right cekKode" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}
	public function update_brand($menuid, $id_category, $ID)
	{
		$data=array
		(
			'name'=>$this->input->post('nama'),
			'id_category'=>$this->input->post('category'),
			'desc'=>$this->input->post('description'),
		);
		$this->db->where('ID',$ID);
		$this->db->update('ms_brand', $data);

		redirect('admin/master/brand/'.$menuid.'/'.$id_category);
	}



	public function service($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_service']    = $this->master_model->select_in('ms_service','*',"ORDER BY ID DESC");

    		$this->load->view('master/service', $data);
    	}


	}


	public function insert_service($menuid)
	{
		$ID = $this->master_model->mst_last_id('ms_service');
		$data = array(
			'ID' => $ID,
			'mechanic' => $this->input->post('mechanic'),
			'name' => $this->input->post('name'),
			'note' => $this->input->post('desc'),
			'price' => $this->input->post('price'),
			'durations' => $this->input->post('duration'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_service', $data);

		redirect('master/service/'.$menuid);
	}


	public function edit_service($menuid)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_service',$ID);
		echo'
			<div class="modal-header">
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              <h4 class="modal-title">Edit Service</h4>
            </div>
            <form method="post" action="'.base_url().'master/update_service/'.$menuid.'/'.$ID.'">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Service Name *</label>
                        <input type="text" name="name" class="form-control" placeholder="Name" required="required" value="'.$data_edit[0]->name.'">
                    </div>

                    <div class="form-group">
                        <label>Mechanic </label>
                        <input type="text" name="mechanic" class="form-control" placeholder="Mechanic" value="'.$data_edit[0]->mechanic.'">
                    </div>

                    <div class="form-group">
                        <label>Durations </label>
                        <input type="number" name="duration" class="form-control" placeholder="Durations" value="'.$data_edit[0]->durations.'">
                    </div>

                    <div class="form-group">
                        <label>Price *</label>
                        <input type="text" name="price" class="form-control" placeholder="Price" value="'.$data_edit[0]->price.'">
                    </div>

                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="desc" class="form-control" placeholder="Description">'.$data_edit[0]->note.'</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
                    <button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px">Close</button>
                </div>
            </form>
		';
	}

	public function update_service($menuid, $ID)
	{
		$data = array(
			'mechanic' => $this->input->post('mechanic'),
			'name' => $this->input->post('name'),
			'note' => $this->input->post('desc'),
			'price' => $this->input->post('price'),
			'durations' => $this->input->post('duration'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_service', $data);

		redirect('master/service/'.$menuid);
	}




	public function edit_model($menuid, $id_category, $id_brand)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_model',$ID);
		echo'
			<form method="post" action="'.base_url().'admin/master/update_model/'.$menuid.'/'.$id_category.'/'.$id_brand.'/'.$ID.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Model</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label>Nama Model *</label>
						<input type="text" name="nama" class="form-control" placeholder="Name Model" required="required" value="'.$data_edit[0]->name.'">
					</div>

					<div class="form-group">
						<label>Brand *</label>
						<select name="brand" required class="form-control">
							';
								$data_brand=$this->master_model->select_in('ms_brand','ID, name',"WHERE id_category=$id_category");

								for($a=0; $a < count($data_brand); $a++)
								{
									if($data_edit[0]->id_brand==$data_brand[$a]->ID)
									{
										$select='selected="selected"';
									}else
									{
										$select='';
									}
									echo'
										<option value="'.$data_brand[$a]->ID.'" '.$select.'>
											'.$data_brand[$a]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>

					<div class="form-group">
						<label>Deskripsi</label>
						<textarea name="description" class="form-control">'.$data_edit[0]->note.'</textarea>
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right cekKode" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function update_model($menuid, $id_category, $id_brand, $ID)
	{
		$id_category  =$this->input->post('id_category');
		$id_brand  =$this->input->post('id_brand');
		$data = array(
			'name' => $this->input->post('product'),
			'id_category' =>$id_category ,
			'id_brand' =>$id_brand ,
			'desc' => $this->input->post('description'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_model', $data);

		redirect('admin/master/model/'.$menuid.'/'.$id_category.'/'.$id_brand);
	}


	public function delete_model($menuid, $id_category, $id_brand, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_model');

		$this->db->where('id_model', $ID);
		$this->db->delete('ms_service');

		$this->db->where('id_spareparts', $ID);
		$this->db->delete('ms_spareparts');

		redirect('admin/master/model/'.$menuid.'/'.$id_category.'/'.$id_brand);
	}







	public function detail($menuid, $id_category, $id_brand, $id_model)
	{
		$data['data_detail'] = $this->master_model->select_in('ms_service', '*', "WHERE id_model=$id_model");

		$this->load->view('admin/master/detail', $data);
	}

	public function insert_detail($menuid, $id_category, $id_brand, $id_model)
	{
		$ID = $this->master_model->mst_last_id('ms_service');
		$data = array(
			'ID' => $ID,
			'id_brand' => $this->input->post('brand'),
			'id_model' => $this->input->post('model'),
			'name' => $this->input->post('name'),
			'durations' => $this->input->post('duration'),
			'price' => $this->input->post('price'),
			'note' => $this->input->post('desc'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_service', $data);

		redirect('admin/master/detail/'.$menuid.'/'.$id_category.'/'.$id_brand.'/'.$id_model);
	}

	public function delete_service($menuid, $ID)
	{
		$ID = $this->input->post('ID');

		$this->db->where('ID', $ID);
		$this->db->delete('ms_service');

		return true;
		//redirect('master/service/'.$menuid);
	}

	public function edit_detail($menuid, $id_category, $id_brand, $id_model)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_service',$ID);
		echo'
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Model</h4>
				</div>
				<form method="post" action="'.base_url().'admin/master/update_detail/'.$menuid.'/'.$id_category.'/'.$id_brand.'/'.$id_model.'/'.$ID.'">
				<div class="modal-body">
					<div class="form-group">
						<label>Nama *</label>
						<input type="text" name="name" class="form-control" placeholder="Name" required="required" value="'.$data_edit[0]->name.'">
					</div>
					<div class="form-group">
						<label>Teknisi *</label>
						<select name="technician" required class="form-control">
							<option value="" selected="selected">
								Pilih Teknisi
							</option>
							';
								$data_technician=$this->master_model->select_in('ms_technician','ID, name',"ORDER BY name ASC");

								for($c=0; $c < count($data_technician); $c++)
								{
									echo'
										<option value="'.$data_technician[$c]->ID.'">
											'.$data_technician[$c]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>
					<div class="form-group">
						<label>Brand *</label>
						<select name="brand" required class="form-control">
							';
								$data_brand=$this->master_model->select_in('ms_brand','ID, name',"WHERE id_category=$id_category");

								for($a=0; $a < count($data_brand); $a++)
								{
									if($data_edit[0]->id_brand==$data_brand[$a]->ID)
									{
										$select='selected="selected"';
									}else
									{
										$select='';
									}
									echo'
										<option value="'.$data_brand[$a]->ID.'" '.$select.'>
											'.$data_brand[$a]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>

					<div class="form-group">
						<label>Model *</label>
						<select name="model" required class="form-control">
							';
								$data_model=$this->master_model->select_in('ms_model','ID, name',"WHERE id_brand=$id_brand");

								for($b=0; $b < count($data_model); $b++)
								{
									if($data_edit[0]->id_model==$data_model[$b]->ID)
									{
										$select='selected="selected"';
									}else
									{
										$select='';
									}
									echo'
										<option value="'.$data_model[$b]->ID.'" '.$select.'>
											'.$data_model[$b]->name.'
										</option>
									';
								}
							echo'
						</select>
					</div>
					<div class="form-group">
						<label>Durasi *</label>
						<input type="text" name="duration" class="form-control" placeholder="Duration" required="required" value="'.$data_edit[0]->durations.'">
					</div>
					<div class="form-group">
						<label>Harga *</label>
						<input type="text" name="price" class="form-control" placeholder="Price" required="required" value="'.$data_edit[0]->price.'">
					</div>
					<div class="form-group">
						<label>Deskripsi</label>
						<textarea name="note" class="form-control" placeholder="Description">'.$data_edit[0]->note.'</textarea>
					</div>
				</div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Simpan" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px">Close</button>
				</div>
			</form>
		';
	}

	public function update_detail($menuid, $id_category, $id_brand, $id_model, $ID)
	{
		$id_category  =$this->input->post('id_category');
		$id_brand  =$this->input->post('id_brand');
		$data = array(
			'name' => $this->input->post('name'),
			'id_technician' =>$this->input->post('technician'),
			'id_brand' =>$this->input->post('brand'),
			'id_model' =>$this->input->post('model'),
			'durations' =>$this->input->post('duration'),
			'price' =>$this->input->post('price'),
			'note' => $this->input->post('note'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_service', $data);

		redirect('admin/master/detail/'.$menuid.'/'.$id_category.'/'.$id_brand.'/'.$id_model);
	}



	public function check_email()
	{
		$email = $this->input->post('email');
		if($email=='')
		{
			echo '2';
		}else
		{
			$cek = $this->master_model->mst_check('ms_customer','email',$email);
			if($cek)
			{
				echo '1';
			}else
			{
				echo '0';
			}
		}
	}
	public function check_phone()
	{
		$phone = $this->input->post('phone');
		if($phone=='')
		{
			echo '2';
		}else
		{
			$cek = $this->master_model->mst_check('ms_customer','phone',$phone);
			if($cek)
			{
				echo '1';
			}else{
				echo '0';
			}
		}
	}


	public function check_email_technician($menuid)
	{
		$email = $this->input->post('email');
		if($email=='')
		{
			echo '2';
		}else
		{
			$cek = $this->master_model->mst_check('ms_technician','email',$email);
			if($cek)
			{
				echo '1';
			}else
			{
				echo '0';
			}
		}
	}
	public function check_phone_technician($menuid)
	{
		$phone = $this->input->post('phone');
		if($phone=='')
		{
			echo '2';
		}else
		{
			$cek = $this->master_model->mst_check('ms_mechanic','phone',$phone);
			if($cek)
			{
				echo '1';
			}else{
				echo '0';
			}
		}
	}

	public function check_name_account($menuid)
	{
		$name = $this->input->post('name');
		if($name=='')
		{
			echo '2';
		}else
		{
			$cek = $this->master_model->mst_check('ms_account','name',$name);
			if($cek)
			{
				echo '1';
			}else{
				echo '0';
			}
		}
	}

	public function check_category()
	{
		$id_category = $this->input->post('id_category');
		if($id_category=='')
		{
			echo '2';
		}else
		{
			//$cek = $this->master_model->mst_check('ms_promo','id_category',$id_category);
			$cek = $this->master_model->check_promo($id_category);
			if($cek)
			{
				echo '1';
			}else{
				echo '0';
			}
		}
	}


	function generate_by_phone()
	{
		$nohp = $this->input->post('nohp');
		$sql = "SELECT ID FROM ms_customer WHERE no_hp = '$nohp' ORDER BY name ASC";
        $qry = $this->db->query($sql);
		$num = $qry->num_rows();
	   if($num == 0)
	   {
		   $gen = $this->master_model->generateOTP(4);
		   echo $gen;
	   }else{
		   echo 'error';
	   }
	}


















	public function mechanic($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_technician']= $this->master_model->mst_data('ms_mechanic');

			$this->load->view('mechanic/main', $data);
	    }
	}


	public function insert_technician($menuid)
	{
		$ID = $this->master_model->mst_last_id('ms_mechanic');
		$data = array(
			'ID' => $ID,
			'name' => $this->input->post('name'),
			'phone' => $this->input->post('phone'),
			'email' => $this->input->post('email'),
			'note' => $this->input->post('note'),
			'status' => $this->input->post('verified'),
			'sort' => $ID,
			'publish' => 1,
		);
		$this->db->insert('ms_mechanic', $data);
		redirect('admin/master/mechanic/'.$menuid);
	}


	public function delete_technician($menuid, $ID)
	{
		$this->db->where('ID', $ID);
		$this->db->delete('ms_mechanic');
		redirect('admin/master/mechanic/'.$menuid);
	}

	public function edit_technician($menuid)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_mechanic',$ID);
		echo'
			<form method="post" action="'.base_url().'master/update_technician/'.$menuid.'/'.$ID.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Mechanic</h4>
				</div>
				<div class="modal-body">
                        <div class="form-group">
                            <label>Mechanic Name *</label>
                            <input type="text" name="name" class="form-control" placeholder="Mechanic Name" required="required" value="'.$data_edit[0]->name.'">
                        </div>

                        <script type="text/javascript">
							$(document).ready(function()
							{
								exist2 = 0;

								$("#phone").change(function (e)
								{
									var phone = $(this).val();
									 $("#phone-result").show();
									$.ajax({
										 type:"POST",
										 url: "'.base_url().'master/check_phone_technician/'.$menuid.',
										 data:"phone="+phone,
										 success:function(msg)
										 {
											 if(msg == 1)
											 {
												 exist2 = 1;
												 $("#phone-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Nomor Handphone sudah digunakan</font>");
											 }else{
												 exist2 = 0;
												 $("#phone-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i> Nomor Handphone belum digunakan</font>");
											 }
										 }
									});
								});
								$("#save").click(function()
								{
									if(exist2 == 1)
									{
										alert("Nomor Handphone Sudah Digunakan");
										return false;
									}else
									{
										return true;
									}
								});
							});
						</script>

                        <div class="form-group">
                            <label>Phone Number</label>
                            <span id="phone-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
                            <input type="text" name="phone" id="phone" class="form-control phone" placeholder="Phone" value="'.$data_edit[0]->phone.'">
                        </div>


                        <div class="form-group">
                            <label>Status</label>
                            <br />
							';
								if($data_edit[0]->status==0)
								{
									echo'
										<input type="radio" name="verified" value="1"/> Verified
                            			<input type="radio" name="verified" value="0" checked="checked" /> Unverified
									';
								}else
								{
									echo'
										<input type="radio" name="verified" value="1" checked="checked" /> Verified
                            			<input type="radio" name="verified" value="0" /> Unverified
									';
								}
							echo'

                        </div>


                        <script type="text/javascript">

							$(document).ready(function()

							{

								exist2 = 0;
								$("#email").change(function (e)
								{
									var email = $(this).val();
									 $("#email-result").show();
									$.ajax({
										 type:"POST",
										 url: "'.base_url().'admin/master/check_email_technician/'.$menuid.'",
										 data:"email="+email,
										 success:function(msg)
										 {
											 if(msg == 1)
											 {
												 exist2 = 1;
												 $("#email-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Email sudah digunakan</font>");
											 }else
											 {
												 exist2 = 0;
												 $("#email-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i> Email belum digunakan</font>");
											 }
										 }
									});
								});

								$("#save").click(function()
								{
									if(exist2 == 1)
									{
										alert("Email Sudah Digunakan");
										return false;
									}else
									{
										return true;
									}
								});
							});
						</script>


                        <div class="form-group">
                            <label>Email</label>
                            <span id="email-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
                            <input type="text" name="email" id="email" class="form-control" placeholder="Email" value="'.$data_edit[0]->email.'">
                        </div>

                         <div class="form-group">
                            <label>Deskription</label>
                            <textarea name="note" class="form-control" placeholder="Description">'.$data_edit[0]->note.'</textarea>
                        </div>

                    </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function supplier($menuid)
	{
		$user_id = $this->session->userdata('user_id');
	    $check=$this->master_model->auth_read($user_id, $menuid);

	    if($check==false)
	    {
	        redirect('NotAuthorized');
	    }else
	    {
	    	$data['data_supplier']= $this->master_model->mst_data('ms_supplier');

			$this->load->view('supplier/main', $data);
	    }
	}

	public function insert_supplier($menuid)
	{
		$ID = $this->master_model->mst_last_id('ms_supplier');
		$data = array(
			'ID' => $ID,
			'name' => $this->input->post('name'),
			'phone' => $this->input->post('phone'),
			'email' => $this->input->post('email'),
			'address' => $this->input->post('address'),
			'status' => $this->input->post('verified'),
			'sort' => $ID,
		);
		$this->db->insert('ms_supplier', $data);
		redirect('admin/master/supplier/'.$menuid);
	}

	public function edit_supplier($menuid)
	{
		$ID = $this->input->post('ID');
		$data_edit=$this->master_model->mst_data_edit('ms_supplier', $ID);
		echo'
			<form method="post" action="'.base_url().'master/update_supplier/'.$menuid.'/'.$ID.'">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal">&times;</button>
				  <h4 class="modal-title">Edit Supplier</h4>
				</div>
				<div class="modal-body">
                        <div class="form-group">
                            <label>Supplier Name *</label>
                            <input type="text" name="name" class="form-control" placeholder="Supplier Name" required="required" value="'.$data_edit[0]->name.'">
                        </div>

                        <script type="text/javascript">
							$(document).ready(function()
							{
								exist2 = 0;

								$("#phone").change(function (e)
								{
									var phone = $(this).val();
									 $("#phone-result").show();
									$.ajax({
										 type:"POST",
										 url: "'.base_url().'master/check_phone_technician/'.$menuid.',
										 data:"phone="+phone,
										 success:function(msg)
										 {
											 if(msg == 1)
											 {
												 exist2 = 1;
												 $("#phone-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Nomor Handphone sudah digunakan</font>");
											 }else{
												 exist2 = 0;
												 $("#phone-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i> Nomor Handphone belum digunakan</font>");
											 }
										 }
									});
								});
								$("#save").click(function()
								{
									if(exist2 == 1)
									{
										alert("Nomor Handphone Sudah Digunakan");
										return false;
									}else
									{
										return true;
									}
								});
							});
						</script>

                        <div class="form-group">
                            <label>Phone Number</label>
                            <span id="phone-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
                            <input type="text" name="phone" id="phone" class="form-control phone" placeholder="Phone" value="'.$data_edit[0]->phone.'">
                        </div>


                        <div class="form-group">
                            <label>Status</label>
                            <br />
							';
								if($data_edit[0]->status==0)
								{
									echo'
										<input type="radio" name="verified" value="1"/> Verified
                            			<input type="radio" name="verified" value="0" checked="checked" /> Unverified
									';
								}else
								{
									echo'
										<input type="radio" name="verified" value="1" checked="checked" /> Verified
                            			<input type="radio" name="verified" value="0" /> Unverified
									';
								}
							echo'

                        </div>


                        <script type="text/javascript">

							$(document).ready(function()

							{

								exist2 = 0;
								$("#email").change(function (e)
								{
									var email = $(this).val();
									 $("#email-result").show();
									$.ajax({
										 type:"POST",
										 url: "'.base_url().'admin/master/check_email_technician/'.$menuid.'",
										 data:"email="+email,
										 success:function(msg)
										 {
											 if(msg == 1)
											 {
												 exist2 = 1;
												 $("#email-result").html("<font style="color:#FF024F"><i class="fa fa-times"></i> Email sudah digunakan</font>");
											 }else
											 {
												 exist2 = 0;
												 $("#email-result").html("<font style="color:#2BB0EA"><i class="fa fa-check" style="color:#2DBE00"></i> Email belum digunakan</font>");
											 }
										 }
									});
								});

								$("#save").click(function()
								{
									if(exist2 == 1)
									{
										alert("Email Sudah Digunakan");
										return false;
									}else
									{
										return true;
									}
								});
							});
						</script>


            <div class="form-group">
                <label>Email</label>
                <span id="email-result" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
                <input type="text" name="email" id="email" class="form-control" placeholder="Email" value="'.$data_edit[0]->email.'">
            </div>

             <div class="form-group">
                <label>Address</label>
                <textarea name="address" class="form-control" placeholder="Address">'.$data_edit[0]->address.'</textarea>
            </div>

        </div>
				<div class="modal-footer">
					<input type="submit" class="btn btn-info btn-fill pull-right" value="Save" id="save">
					<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px;">Close</button>
				</div>
			</form>
		';
	}

	public function update_supplier($menuid, $ID)
	{
		$data = array(
			'name' => $this->input->post('name'),
			'phone' =>$this->input->post('phone') ,
			'email'=>$this->input->post('email'),
			'status' =>$this->input->post('verified') ,
			'address' => $this->input->post('address'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_supplier', $data);

		redirect('master/supplier/'.$menuid);
	}

	public function update_technician($menuid, $ID)
	{
		$data = array(
			'name' => $this->input->post('name'),
			'phone' =>$this->input->post('phone') ,
			'email'=>$this->input->post('email'),
			'status' =>$this->input->post('verified') ,
			'note' => $this->input->post('note'),
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_mechanic', $data);

		redirect('master/mechanic/'.$menuid);
	}

	public function update_poin($menuid)
	{
		$poin=$this->input->post('poin');
		$data=array
		(
			'konversi_poin'=>$poin,
		);
		$this->db->where('id', 1);
		$this->db->update('config_global',$data);
		redirect('master/promo/'.$menuid);
	}
	public function config($menuid)
	{
 		$data['dataConfig'] = $this->master_model->select_in('config_global', '*', "WHERE ID=1");
		$this->load->view('config_global', $data);
	}

	public function update_config_global($menuid)
	{
		if($_FILES['ImageUpload']['name']=='')
		{
			$data = array(
				'name' => $this->input->post('name'),
				'address' => $this->input->post('address'),
				'phone' => $this->input->post('phone'),
				'email' => $this->input->post('email'),
				'news' => $this->input->post('news'),
				'flag' => $this->input->post('publish')
			);
			$this->db->where('ID', 1);
			$this->db->update('config_global', $data);
		}else
		{
			$Image 		= $ID.'.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);
			$Image_temp   = $ID.'_temp.'.substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);

			$config['file_name']      = $ID.'_temp';
			$config['upload_path']    = './uploads/config_global/';
			$config['allowed_types']  = 'gif|jpg|png|';
			$config['max_size']	      = '2000';
			$config['max_width']      = '1500';
			$config['max_height']     = '1500';

			$this->upload->initialize($config);

			if(!$this->upload->do_upload('ImageUpload'))
			{
				$data = array('error' => $this->upload->display_errors('',''));
				$error = $data['error'];
				echo '<script language="javascript">alert("'.$error.'!");window.history.go(-1);</script>';
				exit();
			}else
			{
				$fileImage_temp 	= './uploads/config_global/'.$Image_temp;
				if (file_exists($fileImage_temp)){unlink($fileImage_temp);}
				$fileImage 	= './uploads/config_global/'.$Image;
				if (file_exists($fileImage) && $Image!= ''){unlink($fileImage);}
				$config['file_name']      = $ID;
				$this->upload->initialize($config);
				$this->upload->do_upload('ImageUpload');
			}

			$data = array(
				'name'    => $this->input->post('name'),
				'address' => $this->input->post('address'),
				'phone'   => $this->input->post('phone'),
				'email'   => $this->input->post('email'),
				'news'    => $this->input->post('news'),
				'flag'    => $this->input->post('publish'),
				'image'   => $Image,
			);
			$this->db->where('ID', 1);
			$this->db->update('config_global', $data);
		}

		redirect('master/config/'.$menuid);
	}

	public function spareparts_request($menuid)
	{
		$spareparts= $this->input->post('spareparts');

		$data_spareparts = $this->master_model->select_in('ts_service_spareparts a LEFT JOIN ts_service_detail b ON a.id_service_detail = b.ID LEFT JOIN ts_service c ON b.id_service = c.ID LEFT JOIN ms_supplier d ON a.supplier = d.ID','a.*, c.ID AS id_service, c.invoice, c.date_in, d.name',"WHERE a.sparepart = '$spareparts' AND a.status < 3");
		echo'
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">Data Request ['.$spareparts.']</h4>
			</div>
			<div class="modal-body">
			<table id="example1" class="table table-bordered table-striped">
					<thead>
							<tr>
									<th>No.</th>
									<th>Invoice</th>
									<th>Sparepart</th>
									<th>Date Service</th>
									<th>Indent</th>
									<th>Order Date</th>
									<th>Supplier</th>
									<th>Qty</th>
									<th>Price</th>
									<th>Subtotal</th>
									<th>Status</th>
							</tr>
					</thead>

					<tbody>
							';
								if(count($data_spareparts) == 0)
								{
									echo'
										<tr>
											<td colspan="11">
												No data request available!
											</td>
										</tr>
									';
								}
									for($a=0; $a < count($data_spareparts); $a++)
									{
											$status=$data_spareparts[$a]->status;

											if($status==0)
											{
													$status='<span class="label label-primary">Request</span>';
											}elseif($status==1)
											{
													$status='<span class="label label-info">Ordered</span>';
											}elseif($status==2)
											{
													$status='<span class="label label-warning">Indent</span>';
											}elseif($status==3)
											{
													$status='<span class="tlabel label-success">Ready</span>';
											}elseif($status==4)
											{
													$status='<span class="label label-danger">Canceled</span>';
											}

											if($status==4)
											{
													$status=$status;
											}else
											{
													$status='
															<script>
																	$(function()
																	{
																			$(".status'.$a.'").click(function()
																			{
																				 var ID = $(this).attr("alt");

																				 $.ajax({
																							type: "POST",
																							dataType: "html",
																							url: "'.base_url().'transaction/status_spareparts/'.$menuid.'/'.$data_spareparts[$a]->id_service.'",
																							data: "ID="+ID,
																							success: function(data)
																							{
																									$(".status-modal").html(data);
																							}
																					});
																			});
																	});
															</script>
															<a alt="'.$data_spareparts[$a]->ID.'" class="status'.$a.'" data-toggle="modal" data-target="#status-modal" style="cursor:pointer">
																	'.$status.'
															</a>
													';
											}


											$b=$a+1;

											echo'
													<tr>
															<td>
																	'.$b.'
														 </td>
														 <td>
																	<a alt="'.$data_spareparts[$a]->id_service.'" class="invoice-pop" data-toggle="modal" data-target="#invoice-modal" style="cursor:pointer">
																			'.$data_spareparts[$a]->invoice.'
																	</a>
														 </td>
															<td>
																	<a alt="'.$data_spareparts[$a]->ID.'" class="history text-aqua" data-toggle="modal" data-target="#history-modal" style="cursor:pointer">
																	'.$data_spareparts[$a]->sparepart.'
																	</a>
															</td>
															<td>'.date('d M Y', strtotime($data_spareparts[$a]->date_in)).'
															</td>
															<td>
																	'.$data_spareparts[$a]->indent.' Days
															</td>
															<td>
																	'.date('d M Y', strtotime($data_spareparts[$a]->order_date)).'
															</td>
															<td>
																	'.$data_spareparts[$a]->name.'
															</td>
															<td>
																	'.$data_spareparts[$a]->qty.'
															</td>
															<td>
																	'.str_replace(',','.',number_format($data_spareparts[$a]->price)).'

															</td>
															<td>
																	'.str_replace(',','.',number_format($data_spareparts[$a]->subtotal)).'
															</td>
															<td>
																	'.$status.'
															</td>
													</tr>
											';
									}
									echo'
					</tbody>

			</table>
			</div>
		';
	}

	public function history_spareparts($menuid)
	{
		$ID = $this->input->post('ID');

		$data_history = $this->master_model->select_in('log_activity','*',"WHERE activity = 'Spareparts' AND status < 2 AND id_detail = 0 AND id_spareparts = $ID ORDER BY date_in DESC");
		$count = count($data_history);
		echo'
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">History</h4>
			</div>
			<div class="modal-body">
			<table id="example1" class="table table-bordered table-striped">
					<thead>
							<tr>
									<th>No.</th>
									<th>In</th>
									<th>Out</th>
									<th>Stock</th>
									<th>Date</th>
									<th>Note</th>
									<th>Admin</th>
							</tr>
					</thead>
					<tbody>
							';
								if($count == 0)
								{
									echo'
										<tr>
											<td colspan="6">
												No data history available
											</td>
										</tr>
									';
								}else {
								$data_first = $this->master_model->select_in('log_activity', 'qty_in', "WHERE activity = 'Spareparts' AND status < 2 AND id_detail = 0 AND id_spareparts = $ID AND note = 'Input first stock'");
								$first_stock = $data_first[0]->qty_in;
								$stock = 0;
								for($a=0; $a < count($data_history); $a++)
								{
									$b = $a+1;

									$id_admin = $data_history[$a]->id_admin;
									$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");

									$qty_in = $data_history[$a]->qty_in;
									$qty_out = $data_history[$a]->qty_out;

									echo'
										<tr>
											<td>'.$b.'</td>
											';
												echo'
													<td>'.$data_history[$a]->qty_in.'</td>
													<td>'.$data_history[$a]->qty_out.'</td>
												';
											 echo'
											<td>
												'.$data_history[$a]->qty.'
											</td>
											<td>'.date('d M Y H:i', strtotime($data_history[$a]->date_in)).'</td>
											<td>'.$data_history[$a]->note.'</td>
											<td>'.$data_admin[0]->name.'</td>
										</tr>
									';

								}
							}
							echo'
					</tbody>
		  </table>
			</div>
	 ';
 }

	public function detail_customer($menuid)
	{
		$ID = $this->input->post('ID');

		$get_customer = $this->master_model->select_in('ms_customer', '*', "WHERE ID = $ID");
		if($get_customer[0]->status == 0)
		{
			$status = '<span class="text-red"">Unverified!</span>';
		}else {
			$status = '<span class="text-aqua"><i class="fa fa-check-circle"></i> Verified</span>';
		}

		$select_count = $this->master_model->select_in('ts_service',"count(ID) AS count, SUM(grandtotal) AS grandtotal","WHERE id_customer = $ID ");
		echo'
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">'.$get_customer[0]->name.'</h4>
			</div>
			<div class="modal-body">
				<div class="col-md-4">
					<label>Phone</label>
					<br>
					'.$get_customer[0]->phone.'
					<br>
					<br>
					<label>Email</label>
					<br>
					'.$get_customer[0]->email.'
					<br>
					<br>
					<label>Address</label>
					<br>
					'.$get_customer[0]->address.'
				</div>
				<div class="col-md-4">
					<label>Company</label>
					<br>
					'.$get_customer[0]->company.'
					<br>
					<br>
					<label>Company Phone Number</label>
					<br>
					'.$get_customer[0]->company_phone.'
					<br>
					<br>
					<label>Status</label>
					<br>
					'.$status.'
				</div>
				<div class="col-md-4">
					<label>Count of Service</label>
					<br>
					'.$select_count[0]->count.'
					<br>
					<br>
					<label>Total</label>
					<br>
					Rp'.str_replace(',','.', number_format($select_count[0]->grandtotal)).'
					<br>
					<br>
					<label>Last Activity</label>
					<br>
					'.date('d M Y', strtotime($get_customer[0]->last_activity)).'
				</div>
				<div style="clear: both"></div>
			</div>
			<div class="modal-footer">
				<a href="'.base_url().'master/customer_detail/'.$menuid.'/'.$ID.'" class="btn btn-primary pull-right">
					Detail
				</a>
				<button type="button" class="btn btn-default" data-dismiss="modal" style="margin-right:5px">Close</button>
			</div>
		';
	}

	public function create_barcode()
	{
		$data_spareparts = $this->master_model->select_in('ms_product_spareparts','ID, id_product_subcategory', "");

		for($a=0; $a < count($data_spareparts); $a++)
		{
			$id_spareparts = $data_spareparts[$a]->ID;
			$id_product_subcategory = $data_spareparts[$a]->id_product_subcategory;

			$data_subcategory = $this->master_model->select_in('ms_product_subcategory', 'id_product_category, id_product', "WHERE ID = $id_product_subcategory");

			$data_update= array
			(
				'barcode' => $data_subcategory[0]->id_product.'-'.$data_subcategory[0]->id_product_category.'-'.$id_product_subcategory.'-'.$id_spareparts,
			);
			$this->db->where('ID', $id_spareparts);
			$this->db->update('ms_product_spareparts', $data_update);
		}
	}

	public function get_city($menuid)
	{
		$ID = $this->input->post('ID');

		$data_city = $this->master_model->select_in('ms_city','*',"WHERE id_province = $ID");

		for($a=0; $a < count($data_city); $a++)
		{
			echo'
				<option value="'.$data_city[0]->ID.'">
					'.$data_city[0]->name.'
				</option>
			';
		}
	}

	public function update_stock($menuid, $ID)
	{
		$id_admin = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");
		$value = $this->input->post('value');

		$data_spareparts = $this->master_model->select_in('ms_product_spareparts','name, stock, status, id_product_subcategory',"WHERE ID = $ID");
		$id_product_subcategory = $data_spareparts[0]->id_product_subcategory;
		$stock = $data_spareparts[0]->stock;

		$get_id_category = $this->master_model->select_in('ms_product_subcategory', 'id_product_category', "WHERE ID = $id_product_subcategory");
		$id_product_category = $get_id_category[0]->id_product_category;

		$get_id_product = $this->master_model->select_in('ms_product_category','id_product',"WHERE ID = $id_product_category");

		if($stock == 0)
		{
			$note = 'Input First Stock';
		}else {
			if($stock > $value)
			{
				$note = 'Reduce Qty Spareparts';
				$status_log = 0;
				$value_log = $stock - $value;
				$qty_in = 0;
				$qty_out = $value_log;
			}else {
				$note = 'Add Qty Spareparts';
				$status_log = 1;
				$value_log = $value - $stock;
				$qty_in = $value_log;
				$qty_out = 0;
			}
		}


		$id_log_jobs = $this->master_model->mst_last_id('log_activity');
		$log_jobs = array
		(
			'ID'            => $id_log_jobs,
			'activity'      => 'Spareparts',
			'id_detail'     => 0,
			'id_admin'      => $id_admin,
			'date_in'       => date('Y-m-d H:i:s'),
			'id_spareparts' => $ID,
			'qty'           => $value,
			'qty_in'        => $qty_in,
			'qty_out'       => $qty_out,
			'status'        => $status_log,
			'note'          => $note,
			'sort'          => $id_log_jobs
		);
		$this->db->insert('log_activity', $log_jobs);

		if($data_spareparts[0]->status = 1)
		{
			$status = 0;
		}else
		{
			$status = 0;
		}
		$update_stock = array
		(
			'stock' => $value,
			'status' => $status
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_product_spareparts', $update_stock);

		//echo 'Succesfully '.$note.' Qty Spareparts';
		$arr['url_spareparts'] = $get_id_product[0]->id_product.'/'.$get_id_category[0]->id_product_category.'/'.$id_product_subcategory.'/'.$ID;
		$arr['name_spareparts'] = $data_spareparts[0]->name;
		$arr['date_in_spareparts'] = date('Y-m-d H:i:s');
		$arr['admin_name_spareparts'] = $data_admin[0]->name;
		$arr['note_spareparts'] = $note;

		$arr['status'] = true;
		$count_message_spareparts = $this->master_model->mst_count('log_activity', "activity = 'Spareparts' AND status_read=0");
		$arr['count_message_spareparts'] = $count_message_spareparts;
		echo json_encode($arr);
	}

	public function update_price($menuid, $ID)
	{
		$id_admin = $this->session->userdata('user_id');
		$data_admin = $this->master_model->select_in('user', 'name', "WHERE ID = $id_admin");
		$value = $this->input->post('value');

		$data_spareparts = $this->master_model->select_in('ms_product_spareparts','name, price, status, id_product_subcategory',"WHERE ID = $ID");
		$id_product_subcategory = $data_spareparts[0]->id_product_subcategory;
		$price = $data_spareparts[0]->price;

		$get_id_category = $this->master_model->select_in('ms_product_subcategory', 'id_product_category', "WHERE ID = $id_product_subcategory");
		$id_product_category = $get_id_category[0]->id_product_category;

		$get_id_product = $this->master_model->select_in('ms_product_category','id_product',"WHERE ID = $id_product_category");

		if($value == 0)
		{
			$note = 'Input First Price';
		}else {
			if($price > $value)
			{
				$note = 'Reduce Price Spareparts';
				$status_log = 2;
				$value_log = $price - $value;
				$qty_in = 0;
				$qty_out = $value_log;
			}else {
				$note = 'Add Price Spareparts';
				$status_log = 3;
				$value_log = $value - $price;
				$qty_in = $value_log;
				$qty_out = 0;
			}
		}


		$id_log_jobs = $this->master_model->mst_last_id('log_activity');
		$log_jobs = array
		(
			'ID'            => $id_log_jobs,
			'activity'      => 'Spareparts',
			'id_detail'     => 0,
			'id_admin'      => $id_admin,
			'date_in'       => date('Y-m-d H:i:s'),
			'id_spareparts' => $ID,
			'qty'           => $value,
			'qty_in'        => $qty_in,
			'qty_out'       => $qty_out,
			'status'        => $status_log,
			'note'          => $note,
			'sort'          => $id_log_jobs
		);
		$this->db->insert('log_activity', $log_jobs);


		$update_stock = array
		(
			'price' => $value,
		);
		$this->db->where('ID', $ID);
		$this->db->update('ms_product_spareparts', $update_stock);

		//echo 'Succesfully '.$note.' Qty Spareparts';
		$arr['url_spareparts'] = $get_id_product[0]->id_product.'/'.$get_id_category[0]->id_product_category.'/'.$id_product_subcategory.'/'.$ID;
		$arr['name_spareparts'] = $data_spareparts[0]->name;
		$arr['date_in_spareparts'] = date('Y-m-d H:i:s');
		$arr['admin_name_spareparts'] = $data_admin[0]->name;
		$arr['note_spareparts'] = $note;

		$arr['status'] = true;
		$count_message_spareparts = $this->master_model->mst_count('log_activity', "activity = 'Spareparts' AND status_read=0");
		$arr['count_message_spareparts'] = $count_message_spareparts;
		echo json_encode($arr);
	}


	public function save_download()
 {
	 //Load the library
	    $this->load->library('html2pdf');

	    //Set folder to save PDF to
	    $this->html2pdf->folder('./assets/pdfs/');

	    //Set the filename to save/download as
	    $this->html2pdf->filename('test.pdf');

	    //Set the paper defaults
	    $this->html2pdf->paper('a4', 'portrait');

	    $data = array(
	    	'title' => 'PDF Created',
	    	'message' => 'Hello World!'
	    );

	    //Load html view
	    $this->html2pdf->html($this->load->view('pdf', $data, true));

	    if($this->html2pdf->create('save')) {
	    	//PDF was successfully saved or downloaded
	    	echo 'PDF saved';
	    }
 }

 public function mail_pdf()
    {
		//Load the library
	    $this->load->library('html2pdf');

	    $this->html2pdf->folder('./assets/pdfs/');
	    $this->html2pdf->filename('email_test.pdf');
	    $this->html2pdf->paper('a4', 'portrait');

	    $data = array(
	    	'title' => 'PDF Created',
	    	'message' => 'Hello World!'
	    );
	    //Load html view
	    $this->html2pdf->html($this->load->view('pdf', $data, true));

	    //Check that the PDF was created before we send it
	    if($path = $this->html2pdf->create('save')) {

			$this->load->library('email');
			$this->email->from('your@example.com', 'Your Name');
			$this->email->to('someone@example.com');

			$this->email->subject('Email PDF Test');
			$this->email->message('Testing the email a freshly created PDF');
			$this->email->attach($path);
			$this->email->send();

			echo $this->email->print_debugger();

	    }

    }
}
?>
