<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CurrencyRate extends Model
{
    /**
	 * Eloquent model properties
	 *
	 * @var string
	 */
	protected $table = 'mskurs';
	protected $primaryKey = 'kode_valas';
	public $incrementing = false;
	public $timestamps = false;

	/**
	 * Generates an initial state for a redux application
	 *
	 * @var string json
	 */
	public static function generateInitialState() 
	{
		$rates = self::select('kode_valas AS currency', 'kurs_beli AS buyRate', 'kurs_jual AS sellRate', 'file_bendera AS flagImg')->orderBy('no_urut')->get();

		foreach($rates as $rate) {
			$rate->currency = str_replace(' / IDR', '', $rate->currency);
		}

		return json_encode($rates);
	}
}
