<?php

namespace App\Http\Controllers;

use App\Models\CurrencyRate;
use App\Models\RateListener;
use \Carbon\Carbon;

class RateUpdatesController extends Controller
{
	/**
     * Returns the react application streamer
     *
     * @return void
     */
	public function index()
	{
		$initialState = CurrencyRate::generateInitialState();

		return view('currency-view', compact('initialState'));
	}
	
	/**
     * Receives a batch of currency updates separated by - , updates all rate records accordingly
     *
     * @return void
     */
    public function update($data)
    {
        // Explodes the data string by the delimiter
		$explodedData = explode('-', $data);

		//print_r($explodedData);

		// Categorize the exploded array by the currency code
		$currencyUpdates = [];

		for ($i = 0; $i < count($explodedData); $i++) {
			static $lastCurrency = '';
			if (empty($explodedData[$i])) continue; 
			if ($i % 3 == 0) {
				$explodedData[$i] = strtoupper($explodedData[$i]);
				$currencyUpdates[$explodedData[$i]] = [];
				$lastCurrency = $explodedData[$i];
			}
			else if ($i % 3 == 1) $currencyUpdates[$lastCurrency]['buy'] = $explodedData[$i];
			else if ($i % 3 == 2) $currencyUpdates[$lastCurrency]['sell'] = $explodedData[$i];
		}

		// Updates the currency rate models accordingly
		foreach ($currencyUpdates as $key => $value) {
			$currencyRate = CurrencyRate::where('kode_valas', $key . ' / IDR')->first();
			$currencyRate->kurs_beli = $value['buy'];
			$currencyRate->kurs_jual = $value['sell'];
			$currencyRate->save();
		}

		// Notify the listeners that the rates has changed
		foreach (RateListener::all() as $listener) {
			$listener->updated_timestamp = Carbon::now();
			$listener->save();
		}
    }
}
